/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.tile;

import appeng.api.DimentionalCoord;
import appeng.api.Materials;
import appeng.api.events.GridTileConnectivityEvent;
import appeng.api.exceptions.AppEngTileMissingException;
import appeng.api.me.tiles.IDirectionalMETile;
import appeng.api.me.tiles.IFulllyOptionalMETile;
import appeng.api.me.tiles.IGridTeleport;
import appeng.api.me.tiles.IGridTileEntity;
import appeng.common.AppEng;
import appeng.common.AppEngConfiguration;
import appeng.common.AppEngInternalInventory;
import appeng.common.AppEngTextureRegistry;
import appeng.common.base.AppEngMultiBlock;
import appeng.common.network.IAppEngNetworkTile;
import appeng.interfaces.ICustomCollision;
import appeng.interfaces.InvOperation;
import appeng.me.basetiles.TilePoweredBase;
import appeng.me.cluster.IAECluster;
import appeng.me.cluster.IAEMultiBlock;
import appeng.me.cluster.implementations.QuantumCalculator;
import appeng.me.cluster.implementations.QuantumCluster;
import appeng.me.tile.IInternalInventory;
import appeng.render.AppEngBlockRenderer;
import appeng.util.Platform;
import buildcraft.api.power.PowerHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.Direction;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class TileQuantumBridge
extends TilePoweredBase
implements IAEMultiBlock,
ICustomCollision,
IGridTeleport,
IFulllyOptionalMETile,
IGridTileEntity,
IAppEngNetworkTile,
IDirectionalMETile,
IInventory {
    public AppEngInternalInventory inv;
    final byte start = (byte)15;
    public final byte corner = (byte)16;
    final byte hasSingularity = (byte)32;
    final byte powered = (byte)64;
    private QuantumCalculator calc = new QuantumCalculator(this);
    public boolean bridgePowered;
    int oldxdex = -1;
    byte xdex;
    QuantumCluster clust;

    public TileQuantumBridge() {
        this.updateStatus(null, (byte)-1);
        this.inv = new AppEngInternalInventory(this, 1);
        this.inv.setMaxStackSize(1);
    }

    public void updateStatus(QuantumCluster obj, byte dex) {
        boolean hasCust = this.clust != null;
        this.xdex = dex;
        this.clust = obj;
        this.updatePowerCosts();
    }

    private void updatePowerCosts() {
        this.maxStoredPower = this.clust != null ? (!this.isCorner() || this.isCenter() ? 10.0f * AppEngConfiguration.perTickNetworkBridge : 0.0f) : 0.0f;
    }

    @Override
    public void updateTileEntity() {
        super.updateTileEntity();
        if (Platform.isClient()) {
            boolean hasSingularityS;
            if (!this.isCenter() || this.xdex == -1) {
                return;
            }
            boolean hasPower = (this.xdex & 0x40) == 64;
            boolean bl = hasSingularityS = (this.xdex & 0x20) == 32;
            if (hasSingularityS && (this.xdex & 0xF) > 0) {
                AppEng.getInstance().SideProxy.SingularityEffect(this);
            }
            return;
        }
        this.updatePowerCosts();
        if (this.clust != null) {
            if (this.isCenter()) {
                boolean oldPower = this.bridgePowered;
                this.bridgePowered = this.useMEEnergy(AppEngConfiguration.perTickNetworkBridge, "NetworkBridge");
                if (oldPower != this.bridgePowered && this.clust != null) {
                    this.clust.updateStatus(true);
                    this.clust.updateRender();
                }
            } else if (this.storedPower > 0.0f) {
                try {
                    this.storedPower = (float)this.clust.getCenter().getTile().addMEPower(this.storedPower);
                }
                catch (AppEngTileMissingException e) {
                    AppEng.log("Unable to submit power to QNB");
                }
            }
        }
        if (this.oldxdex != this.xdex) {
            this.oldxdex = this.xdex;
            this.tickUpdateCount = 0;
            this.markForUpdate();
            this.updatePowerConnectivity();
            MinecraftForge.EVENT_BUS.post((Event)new GridTileConnectivityEvent(this, this.field_70331_k, this.getLocation()));
        }
    }

    @Override
    public boolean requiresTickingUpdates() {
        return true;
    }

    boolean isCorner() {
        return (this.xdex & 0x10) == 16;
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, Direction direction) {
        return !this.isCorner() && !this.isCenter();
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return !this.isCorner() && !this.isCenter();
    }

    @Override
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        if (this.isCorner()) {
            return null;
        }
        return super.getPowerReceiver(side);
    }

    @Override
    public boolean isMachineActive() {
        if (this.clust == null) {
            return false;
        }
        if (!AppEngConfiguration.requirePower) {
            return true;
        }
        return this.clust.hasPower();
    }

    @Override
    public boolean isEnabled() {
        return !this.isSeperated() && this.isMachineActive();
    }

    @Override
    public boolean isSeperated() {
        return this.isCorner();
    }

    @Override
    public boolean canInterface(ForgeDirection direction) {
        if (this.isCenter()) {
            TileEntity te = this.field_70331_k.func_72796_p(this.field_70329_l + direction.offsetX, this.field_70330_m + direction.offsetY, this.field_70327_n + direction.offsetZ);
            return this.clust != null && te instanceof TileQuantumBridge;
        }
        return !this.isCorner();
    }

    @Override
    public boolean canConnect(ForgeDirection direction) {
        if (this.isCenter()) {
            TileEntity te = this.field_70331_k.func_72796_p(this.field_70329_l + direction.offsetX, this.field_70330_m + direction.offsetY, this.field_70327_n + direction.offsetZ);
            return this.clust != null && te instanceof TileQuantumBridge;
        }
        return !this.isCorner();
    }

    @Override
    public int getLightValue() {
        return 0;
    }

    @Override
    public int getLightOpacity() {
        return 1;
    }

    @Override
    public Icon getBlockTextureFromSide(ForgeDirection dir) {
        if (this.isCenter()) {
            return AppEngTextureRegistry.Blocks.BlockQLink.get();
        }
        if (this.xdex == -1) {
            return AppEngTextureRegistry.Blocks.BlockQRingEdge.get();
        }
        if (this.isCorner()) {
            return AppEngTextureRegistry.Blocks.BlockQRingCorner.get();
        }
        return AppEngTextureRegistry.Blocks.BlockQRingEdge.get();
    }

    @SideOnly(value=Side.CLIENT)
    public void renderCableAt(double Thickness, IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer, Icon texture, boolean center, double pull) {
        AppEngBlockRenderer AppEngRenderer = AppEngBlockRenderer.instance;
        AppEngRenderer.setOverrideBlockTexture(block, texture);
        if (this.connectsTo(world, x - 1, y, z)) {
            renderer.func_83020_a(0.0, 0.5 - Thickness, 0.5 - Thickness, 0.5 - Thickness - pull, 0.5 + Thickness, 0.5 + Thickness);
            renderer.func_78570_q(block, x, y, z);
        }
        if (this.connectsTo(world, x + 1, y, z)) {
            renderer.func_83020_a(0.5 + Thickness + pull, 0.5 - Thickness, 0.5 - Thickness, 1.0, 0.5 + Thickness, 0.5 + Thickness);
            renderer.func_78570_q(block, x, y, z);
        }
        if (this.connectsTo(world, x, y, z - 1)) {
            renderer.func_83020_a(0.5 - Thickness, 0.5 - Thickness, 0.0, 0.5 + Thickness, 0.5 + Thickness, 0.5 - Thickness - pull);
            renderer.func_78570_q(block, x, y, z);
        }
        if (this.connectsTo(world, x, y, z + 1)) {
            renderer.func_83020_a(0.5 - Thickness, 0.5 - Thickness, 0.5 + Thickness + pull, 0.5 + Thickness, 0.5 + Thickness, 1.0);
            renderer.func_78570_q(block, x, y, z);
        }
        if (this.connectsTo(world, x, y - 1, z)) {
            renderer.func_83020_a(0.5 - Thickness, 0.0, 0.5 - Thickness, 0.5 + Thickness, 0.5 - Thickness - pull, 0.5 + Thickness);
            renderer.func_78570_q(block, x, y, z);
        }
        if (this.connectsTo(world, x, y + 1, z)) {
            renderer.func_83020_a(0.5 - Thickness, 0.5 + Thickness + pull, 0.5 - Thickness, 0.5 + Thickness, 1.0, 0.5 + Thickness);
            renderer.func_78570_q(block, x, y, z);
        }
        AppEngRenderer.setOverrideBlockTexture(block, null);
    }

    private boolean connectsTo(IBlockAccess world, int x, int i, int z) {
        TileEntity te = world.func_72796_p(x, i, z);
        if (Platform.isClient() ? te instanceof TileQuantumBridge && this.xdex != -1 : te instanceof TileQuantumBridge) {
            return !((TileQuantumBridge)te).isCorner();
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        renderer.field_78661_f = true;
        if (this.isCenter()) {
            this.renderCableAt(0.11, world, x, y, z, block, modelId, renderer, AppEngTextureRegistry.Blocks.BlockMEQlink.get(), true, 0.141);
            this.renderCableAt(0.188, world, x, y, z, block, modelId, renderer, AppEngTextureRegistry.Blocks.MECable.get(), false, 0.1875);
            float px = 0.125f;
            float maxpx = 0.875f;
            renderer.func_83020_a((double)px, (double)px, (double)px, (double)maxpx, (double)maxpx, (double)maxpx);
            renderer.func_78570_q(block, x, y, z);
        } else if (this.xdex == -1) {
            float px = 0.125f;
            float maxpx = 0.875f;
            renderer.func_83020_a((double)px, (double)px, (double)px, (double)maxpx, (double)maxpx, (double)maxpx);
            renderer.func_78570_q(block, x, y, z);
        } else if (this.isCorner()) {
            this.renderCableAt(0.188, world, x, y, z, block, modelId, renderer, AppEngTextureRegistry.Blocks.MECable.get(), false, 0.05);
            float px = 0.25f;
            float maxpx = 0.75f;
            renderer.func_83020_a((double)px, (double)px, (double)px, (double)maxpx, (double)maxpx, (double)maxpx);
            renderer.func_78570_q(block, x, y, z);
            if ((this.xdex & 0x40) == 64) {
                AppEngBlockRenderer AppEngRenderer = AppEngBlockRenderer.instance;
                AppEngRenderer.setOverrideBlockTexture(block, AppEngTextureRegistry.Blocks.BlockQRingCornerLight.get());
                px = 0.24375f;
                maxpx = 0.75625f;
                renderer.func_83020_a((double)px, (double)px, (double)px, (double)maxpx, (double)maxpx, (double)maxpx);
                int bn = 15;
                Tessellator.field_78398_a.func_78386_a(1.0f, 1.0f, 1.0f);
                Tessellator.field_78398_a.func_78380_c(bn << 20 | bn << 4);
                for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                    this.renderFace(block, renderer, side);
                }
                AppEngRenderer.setOverrideBlockTexture(block, null);
            }
        } else {
            float px = 0.125f;
            float maxpx = 0.875f;
            renderer.func_83020_a(0.0, (double)px, (double)px, 1.0, (double)maxpx, (double)maxpx);
            renderer.func_78570_q(block, x, y, z);
            renderer.func_83020_a((double)px, 0.0, (double)px, (double)maxpx, 1.0, (double)maxpx);
            renderer.func_78570_q(block, x, y, z);
            renderer.func_83020_a((double)px, (double)px, 0.0, (double)maxpx, (double)maxpx, 1.0);
            renderer.func_78570_q(block, x, y, z);
            if ((this.xdex & 0x40) == 64) {
                AppEngBlockRenderer AppEngRenderer = AppEngBlockRenderer.instance;
                AppEngRenderer.setOverrideBlockTexture(block, AppEngTextureRegistry.Blocks.BlockQRingEdgeLight.get());
                px = -6.25E-4f;
                maxpx = 1.000625f;
                renderer.func_83020_a((double)px, (double)px, (double)px, (double)maxpx, (double)maxpx, (double)maxpx);
                int bn = 15;
                Tessellator.field_78398_a.func_78386_a(1.0f, 1.0f, 1.0f);
                Tessellator.field_78398_a.func_78380_c(bn << 20 | bn << 4);
                for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                    this.renderFace(block, renderer, side);
                }
                AppEngRenderer.setOverrideBlockTexture(block, null);
            }
        }
        renderer.field_78661_f = false;
        return true;
    }

    @Override
    protected void terminate() {
        this.disconnect();
        super.terminate();
    }

    @Override
    public void disconnect() {
        if (this.clust != null) {
            this.clust.destroy();
            this.clust = null;
        }
    }

    @Override
    public void onNeighborBlockChange() {
        this.calc.calculateMultiblock((IBlockAccess)this.field_70331_k, this.getLocation());
        this.updatePowerCosts();
    }

    private boolean isCenter() {
        return this.field_70331_k != null && this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m, this.field_70327_n) == AppEng.getInstance().registration.blkQuantumLink.getMetaData();
    }

    @Override
    public void func_70307_a(NBTTagCompound par1nbtTagCompound) {
        super.func_70307_a(par1nbtTagCompound);
        this.inv.readFromNBT(par1nbtTagCompound);
    }

    @Override
    public void func_70310_b(NBTTagCompound par1nbtTagCompound) {
        super.func_70310_b(par1nbtTagCompound);
        this.inv.writeToNBT(par1nbtTagCompound);
    }

    @Override
    public boolean isBlockNormalCube() {
        return false;
    }

    @Override
    public void configureTilePacket(DataOutputStream data) throws IOException {
        boolean hasPowerVal = false;
        boolean hasQES = false;
        if (this.clust != null) {
            hasPowerVal = this.clust.hasPower();
            hasQES = this.clust.hasQES();
        }
        data.writeByte(this.xdex | (hasQES ? 32 : 0) | (hasPowerVal ? 64 : 0));
    }

    @Override
    public boolean handleTilePacket(DataInputStream stream) throws IOException {
        this.oldxdex = this.xdex;
        this.xdex = stream.readByte();
        return this.xdex != this.oldxdex;
    }

    @Override
    public boolean syncStyle(IAppEngNetworkTile.SyncTime st) {
        return st == IAppEngNetworkTile.SyncTime.WORLD;
    }

    @Override
    protected int getMaxStoredPower() {
        return 0;
    }

    @Override
    public void InvChanged(IInternalInventory invv, int slot, InvOperation Operation) {
        if (invv == this.inv && this.clust != null) {
            this.clust.updateStatus(true);
            this.markForUpdate();
        }
    }

    @Override
    public DimentionalCoord[] findRemoteSide() {
        if (this.isEnabled() && this.clust != null && this.isMachineActive()) {
            return this.clust.getOtherSide();
        }
        return new DimentionalCoord[0];
    }

    public long getQEDest() {
        if (this.isCenter() && this.inv.func_70301_a(0) != null) {
            NBTTagCompound cmp = Platform.openNbtData(this.inv.func_70301_a(0));
            return cmp.func_74763_f("freq");
        }
        return 0L;
    }

    @Override
    public boolean useMEEnergy(float use, String for_what) {
        if (!AppEngConfiguration.requirePower) {
            return true;
        }
        if (this.storedPower >= (use *= AppEngConfiguration.powerUsageMultiplier)) {
            this.storedPower -= use;
            return true;
        }
        this.storedPower = 0.0f;
        this.func_70296_d();
        return false;
    }

    public void updateGrid() {
        MinecraftForge.EVENT_BUS.post((Event)new GridTileConnectivityEvent(this, this.field_70331_k, this.getLocation()));
        AppEng.getInstance().GridManager.forceNetworkReclculation(this);
    }

    @Override
    public void addCollidingBlockToList(World world, int x, int y, int z, AxisAlignedBB axisalignedbb, List arraylist, Entity par7Entity) {
        AppEngMultiBlock blk = (AppEngMultiBlock)this.func_70311_o();
        float thickness = 0.38f;
        if (this.xdex == -1 || this.isCenter()) {
            float xminPos = 0.5f - thickness;
            float xmaxPos = 0.5f + thickness;
            float yminPos = 0.5f - thickness;
            float ymaxPos = 0.5f + thickness;
            float zminPos = 0.5f - thickness;
            float zmaxPos = 0.5f + thickness;
            AxisAlignedBB b = AxisAlignedBB.func_72332_a().func_72299_a((double)xminPos, (double)yminPos, (double)zminPos, (double)xmaxPos, (double)ymaxPos, (double)zmaxPos);
            blk.func_71905_a((float)b.field_72340_a, (float)b.field_72338_b, (float)b.field_72339_c, (float)b.field_72336_d, (float)b.field_72337_e, (float)b.field_72334_f);
            blk.configureCollidingBlockToList(world, x, y, z, axisalignedbb, arraylist, par7Entity);
            blk.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        } else if (this.isCorner()) {
            blk.func_71905_a(0.2f, 0.2f, 0.2f, 0.8f, 0.8f, 0.8f);
            blk.configureCollidingBlockToList(world, x, y, z, axisalignedbb, arraylist, par7Entity);
            blk.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        } else {
            blk.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            blk.configureCollidingBlockToList(world, x, y, z, axisalignedbb, arraylist, par7Entity);
        }
    }

    @Override
    public AxisAlignedBB[] getSelectedBoundingBoxsFromPool(World world, int i, int j, int k) {
        float thickness = 0.38f;
        float xminPos = 0.5f - thickness;
        float xmaxPos = 0.5f + thickness;
        float yminPos = 0.5f - thickness;
        float ymaxPos = 0.5f + thickness;
        float zminPos = 0.5f - thickness;
        float zmaxPos = 0.5f + thickness;
        ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
        if (this.xdex == -1 || this.isCenter()) {
            boxes.add(AxisAlignedBB.func_72332_a().func_72299_a((double)xminPos, (double)yminPos, (double)zminPos, (double)xmaxPos, (double)ymaxPos, (double)zmaxPos));
        } else if (this.isCorner()) {
            boxes.add(AxisAlignedBB.func_72332_a().func_72299_a(0.25, 0.25, 0.25, 0.75, 0.75, 0.75));
        } else {
            boxes.add(AxisAlignedBB.func_72332_a().func_72299_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
        }
        return boxes.toArray(new AxisAlignedBB[boxes.size()]);
    }

    public int func_70302_i_() {
        if (this.isCenter()) {
            return this.inv.func_70302_i_();
        }
        return 0;
    }

    public ItemStack func_70301_a(int i) {
        if (this.isCenter()) {
            return this.inv.func_70301_a(i);
        }
        return null;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.isCenter()) {
            return this.inv.func_70298_a(i, j);
        }
        return null;
    }

    public ItemStack func_70304_b(int i) {
        if (this.isCenter()) {
            return this.inv.func_70304_b(i);
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        if (this.isCenter()) {
            this.inv.func_70299_a(i, itemstack);
        }
    }

    public String func_70303_b() {
        return "Quantum Network Bridge";
    }

    public boolean func_94042_c() {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return Platform.isSameItemType(itemstack, Materials.matQuantumEntangledSingularity);
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.isCommonUseableByPlayer(entityplayer);
    }

    @Override
    public boolean isPublicPowerStorage() {
        return false;
    }

    @Override
    public double drainMEPower(double amt) {
        return 0.0;
    }

    @Override
    public IAECluster getCluster() {
        return this.clust;
    }
}

