/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.tile;

import appeng.api.IAEItemStack;
import appeng.api.events.GridStorageUpdateEvent;
import appeng.api.me.tiles.ICellContainer;
import appeng.api.me.tiles.ICellProvider;
import appeng.api.me.tiles.IGridMachine;
import appeng.api.me.tiles.IOrientableTile;
import appeng.api.me.tiles.IPriorityTile;
import appeng.api.me.util.IGridInterface;
import appeng.api.me.util.IMEInventoryHandler;
import appeng.common.AppEng;
import appeng.common.AppEngConfiguration;
import appeng.common.AppEngInternalInventory;
import appeng.common.AppEngTextureRegistry;
import appeng.common.network.IAppEngNetworkTile;
import appeng.common.registries.AppEngCellRegistry;
import appeng.gui.AppEngGuiHandler;
import appeng.interfaces.IBlinky;
import appeng.interfaces.ICellFeedBack;
import appeng.interfaces.IMEInterfaceHandlerExtended;
import appeng.interfaces.INetworkNotifiable;
import appeng.interfaces.InvOperation;
import appeng.me.MEInventoryNetwork;
import appeng.me.basetiles.TilePoweredBase;
import appeng.me.tile.IInternalInventory;
import appeng.me.tile.TileController;
import appeng.util.ItemList;
import appeng.util.Platform;
import buildcraft.api.inventory.ISpecialInventory;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class TileChest
extends TilePoweredBase
implements IBlinky,
IOrientableTile,
INetworkNotifiable,
ICellFeedBack,
ICellContainer,
IPriorityTile,
IInventory,
ICellProvider,
ISpecialInventory,
IAppEngNetworkTile,
IGridMachine {
    public AppEngInternalInventory cellinv = new AppEngInternalInventory(this, 1);
    public AppEngInternalInventory buffer = new AppEngInternalInventory(this, 1);
    int priority = 1;
    public byte cheststatus;
    boolean wasPowered = false;
    public ForgeDirection orientation;
    List<IMEInventoryHandler> cachedCellArray;
    public List<IAEItemStack> invChanges;
    int bdelay = 0;
    int blink = 0;

    @Override
    public boolean syncStyle(IAppEngNetworkTile.SyncTime st) {
        return true;
    }

    @Override
    public List<IMEInventoryHandler> getCellArray() {
        if (this.cachedCellArray != null) {
            return this.cachedCellArray;
        }
        ItemStack s = this.cellinv.func_70301_a(0);
        if (s != null && AppEngCellRegistry.isCell(s)) {
            IMEInventoryHandler inv = AppEngCellRegistry.getCellHandler(s);
            inv.setUpdateTarget(this);
            if (inv instanceof IMEInterfaceHandlerExtended) {
                ((IMEInterfaceHandlerExtended)inv).setCellIndex(2);
            }
            this.cachedCellArray = new ArrayList<IMEInventoryHandler>();
            this.cachedCellArray.add(inv);
            return this.cachedCellArray;
        }
        this.cachedCellArray = new ArrayList<IMEInventoryHandler>();
        return this.cachedCellArray;
    }

    public void applyCellChanges(boolean subtract) {
        TileController tc;
        if (this.cachedCellArray == null && subtract) {
            return;
        }
        ItemList Il = new ItemList();
        List<IMEInventoryHandler> cellArray = this.getCellArray();
        if (cellArray != null) {
            for (IMEInventoryHandler ih : cellArray) {
                ih.getAvailableItems(Il);
            }
        }
        if (this.getGrid() != null && (tc = (TileController)this.getGrid().getController()) != null) {
            for (IAEItemStack is : Il) {
                if (subtract) {
                    tc.notifyExtractItems(is);
                    continue;
                }
                tc.notifyAddItems(is);
            }
        }
    }

    @Override
    public void InvChanged(IInternalInventory inv, int slot, InvOperation Operation) {
        if (inv == this.cellinv && Operation != InvOperation.onInventoryChanged && this.field_70331_k != null) {
            this.applyCellChanges(true);
            this.resetCache();
            this.triggerPowerUpdate();
            this.markForUpdate();
            this.invChanges.clear();
            this.triggerContainerUpdate();
            this.applyCellChanges(false);
        }
    }

    @Override
    public void afterContainerUpdate() {
        this.invChanges.clear();
    }

    @Override
    public boolean isMachineActive() {
        if (!AppEngConfiguration.requirePower) {
            return true;
        }
        if (super.isMachineActive()) {
            return true;
        }
        return this.storedPower > 0.0f;
    }

    @Override
    public void actionHandler(EntityPlayerMP pmp, int action, DataInputStream stream) {
        try {
            if (action == 1) {
                this.setPriority(stream.readInt());
                this.markForUpdate();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public TileChest() {
        this.maxStoredPower = 3000.0f;
        this.orientation = ForgeDirection.NORTH;
        this.invChanges = new ArrayList<IAEItemStack>();
    }

    @Override
    public boolean getDrops(World w, int x, int y, int z, List<ItemStack> drops) {
        ItemStack is;
        int l;
        AppEngInternalInventory inv = this.buffer;
        for (l = 0; l < inv.func_70302_i_(); ++l) {
            is = inv.func_70301_a(l);
            if (is == null) continue;
            drops.add(is);
            inv.func_70299_a(l, null);
        }
        inv = this.cellinv;
        for (l = 0; l < inv.func_70302_i_(); ++l) {
            is = inv.func_70301_a(l);
            if (is == null) continue;
            drops.add(is);
            inv.func_70299_a(l, null);
        }
        return true;
    }

    @Override
    public int getLightOpacity() {
        return 1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        renderer.func_83020_a(0.02, 0.0, 0.02, 0.98, 0.98, 0.98);
        renderer.field_78661_f = true;
        if (AppEngConfiguration.gfxDrivesHighDef) {
            renderer.func_78570_q(block, x, y, z);
            if ((this.cheststatus & 1) == 1) {
                int bn = 9;
                float u = 6.0f;
                float v = 1.0f;
                if ((this.cheststatus & 0x10) > 0) {
                    if ((this.cheststatus & 4) == 4) {
                        u = 1.0f;
                        v = 9.0f;
                    } else if ((this.cheststatus & 8) == 8) {
                        u = 1.0f;
                        v = 5.0f;
                    } else {
                        u = 1.0f;
                        v = 1.0f;
                    }
                }
                Icon parts = AppEngTextureRegistry.Blocks.BlockHDChestTopParts.get();
                float offsetPerPixel = 0.0625f;
                float[] p1 = new float[5];
                float[] p2 = new float[5];
                float[] p3 = new float[5];
                float[] p4 = new float[5];
                p1[0] = 4.0f * offsetPerPixel;
                p1[1] = 0.981f;
                p1[2] = 4.0f * offsetPerPixel;
                p1[3] = u;
                p1[4] = v;
                p2[0] = p1[0] + offsetPerPixel * 4.0f;
                p2[1] = p1[1];
                p2[2] = p1[2];
                p2[3] = p1[3] + 4.0f;
                p2[4] = p1[4];
                p3[0] = p1[0] + offsetPerPixel * 4.0f;
                p3[1] = p1[1];
                p3[2] = p1[2] + offsetPerPixel * 3.0f;
                p3[3] = p1[3] + 4.0f;
                p3[4] = p1[4] + 3.0f;
                p4[0] = p1[0];
                p4[1] = p1[1];
                p4[2] = p1[2] + offsetPerPixel * 3.0f;
                p4[3] = p1[3];
                p4[4] = p1[4] + 3.0f;
                Tessellator tess = Tessellator.field_78398_a;
                if ((this.cheststatus & 0x10) > 0) {
                    tess.func_78380_c(bn << 20 | bn << 4);
                } else {
                    tess.func_78380_c(block.func_71874_e((IBlockAccess)this.field_70331_k, x, y + 1, z));
                }
                tess.func_78374_a((double)((float)x + p4[0]), (double)((float)y + p4[1]), (double)((float)z + p4[2]), (double)parts.func_94214_a((double)p4[3]), (double)parts.func_94207_b((double)p4[4]));
                tess.func_78374_a((double)((float)x + p3[0]), (double)((float)y + p3[1]), (double)((float)z + p3[2]), (double)parts.func_94214_a((double)p3[3]), (double)parts.func_94207_b((double)p3[4]));
                tess.func_78374_a((double)((float)x + p2[0]), (double)((float)y + p2[1]), (double)((float)z + p2[2]), (double)parts.func_94214_a((double)p2[3]), (double)parts.func_94207_b((double)p2[4]));
                tess.func_78374_a((double)((float)x + p1[0]), (double)((float)y + p1[1]), (double)((float)z + p1[2]), (double)parts.func_94214_a((double)p1[3]), (double)parts.func_94207_b((double)p1[4]));
            }
        } else {
            renderer.func_78570_q(block, x, y, z);
        }
        renderer.field_78661_f = false;
        return true;
    }

    @Override
    public boolean isBlockNormalCube() {
        return false;
    }

    public int func_70302_i_() {
        return 1;
    }

    @Override
    public float getPowerDrainPerTick() {
        if (this.cellinv.func_70301_a(0) != null) {
            return 1.0f + this.getStoragePowerUsage(this.getCellArray());
        }
        return 1.0f;
    }

    @Override
    public void updateTileEntity() {
        if (Platform.isClient()) {
            if (this.bdelay-- < 0 && this.blink > 0) {
                this.blink = 0;
                this.bdelay = 0;
            }
            return;
        }
        super.updateTileEntity();
        if (this.cellinv.func_70301_a(0) != null) {
            IGridInterface i = this.getGrid();
            if (i == null) {
                this.useMEEnergy(this.getPowerDrainPerTick(), "chestPower");
            }
            if (this.isMachineActive() && !this.wasPowered || !this.isMachineActive() && this.wasPowered) {
                this.wasPowered = this.isMachineActive();
                this.markForUpdate();
            }
            this.ManageInventory();
        }
    }

    public void ManageInventory() {
        if (this.cellinv.func_70301_a(0) != null) {
            ItemStack input = this.buffer.func_70301_a(0);
            if (input != null) {
                IGridInterface i = this.getGrid();
                IMEInventoryHandler mei = this.provideCell();
                if (mei != null) {
                    ItemStack output = null;
                    output = Platform.addItems(mei, input);
                    this.buffer.func_70299_a(0, output);
                }
            }
        } else if (this.buffer.func_70301_a(0) != null) {
            ArrayList<ItemStack> out = new ArrayList<ItemStack>();
            out.add(this.buffer.func_70301_a(0));
            this.buffer.func_70299_a(0, null);
            Platform.spawnDrops(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, out);
        }
    }

    public ItemStack func_70301_a(int var1) {
        return this.buffer.func_70301_a(var1);
    }

    @Override
    public IMEInventoryHandler provideCell() {
        boolean isPower;
        boolean bl = Platform.isClient() ? (this.cheststatus & 0x10) == 16 : (isPower = this.isMachineActive());
        if (isPower) {
            List<IMEInventoryHandler> igh = this.getCellArray();
            if (igh == null) {
                return null;
            }
            if (igh.isEmpty()) {
                return null;
            }
            IMEInventoryHandler ih = igh.get(0);
            if (this.getGrid() == null) {
                return ih;
            }
            ArrayList<IMEInventoryHandler> inv = new ArrayList<IMEInventoryHandler>();
            inv.add(ih);
            return MEInventoryNetwork.getMEInventoryNetwork(inv, (TileController)this.getGrid().getController(), new ItemList());
        }
        return null;
    }

    void resetCache() {
        if (this.getGrid() != null) {
            MinecraftForge.EVENT_BUS.post((Event)new GridStorageUpdateEvent(this.field_70331_k, this.getLocation(), this.getGrid()));
        }
        this.cachedCellArray = null;
        if (this.getGrid() != null) {
            this.getGrid().resetWaitingQueue();
        }
    }

    public ItemStack func_70298_a(int var1, int var2) {
        return this.buffer.func_70298_a(var1, var2);
    }

    public ItemStack func_70304_b(int var1) {
        return null;
    }

    public void func_70299_a(int var1, ItemStack var2) {
        this.buffer.func_70299_a(var1, var2);
    }

    public String func_70303_b() {
        return "ME Chest";
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public void openGui(EntityPlayer p) {
        Platform.openGui(p, AppEngGuiHandler.GUI_CHEST, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public Icon getBlockTextureFromSide(ForgeDirection side) {
        if (ForgeDirection.DOWN == side) {
            return AppEngTextureRegistry.Blocks.GenericBottom.get();
        }
        if (ForgeDirection.UP == side) {
            if (AppEngConfiguration.gfxDrivesHighDef) {
                return AppEngTextureRegistry.Blocks.BlockHDChestTop.get();
            }
            return (this.cheststatus & 1) == 1 ? AppEngTextureRegistry.Blocks.BlockChestTopGreen.get() : AppEngTextureRegistry.Blocks.BlockChestTopRed.get();
        }
        if (this.orientation == side) {
            return AppEngTextureRegistry.Blocks.BlockChestFront.get();
        }
        return AppEngTextureRegistry.Blocks.BlockChestSide.get();
    }

    @Override
    public void placedBy(EntityLivingBase entityliving) {
        this.orientation = this.getOrientationFromLivingEntity(entityliving, false);
    }

    @Override
    public void func_70307_a(NBTTagCompound tagCompound) {
        super.func_70307_a(tagCompound);
        try {
            if (tagCompound.func_74764_b("cell")) {
                NBTTagCompound src = tagCompound.func_74775_l("cell");
                NBTTagCompound o = new NBTTagCompound();
                o.func_74766_a("#0", src);
                this.cellinv.readFromNBT(o);
            } else {
                this.cellinv.readFromNBT(tagCompound.func_74775_l("storagecell"));
            }
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        try {
            this.buffer.readFromNBT(tagCompound.func_74775_l("buffer"));
            this.orientation = this.getDirectionFromAERotation(tagCompound.func_74771_c("rotation"));
            this.priority = tagCompound.func_74762_e("priority");
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound tagCompound) {
        super.func_70310_b(tagCompound);
        try {
            NBTTagCompound cellinventory = new NBTTagCompound();
            this.cellinv.writeToNBT(cellinventory);
            tagCompound.func_74766_a("storagecell", cellinventory);
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        try {
            NBTTagCompound blockBuffer = new NBTTagCompound();
            this.buffer.writeToNBT(blockBuffer);
            tagCompound.func_74766_a("buffer", blockBuffer);
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        try {
            tagCompound.func_74774_a("rotation", this.getAERotationFromDirection(this.orientation));
            tagCompound.func_74768_a("priority", this.priority);
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    @Override
    public boolean handleTilePacket(DataInputStream stream) throws IOException {
        ForgeDirection oldorientation = this.orientation;
        byte oldcheststatus = this.cheststatus;
        int oldblink = this.blink;
        this.priority = stream.readInt();
        this.orientation = this.getDirectionFromAERotation(stream.readByte());
        this.cheststatus = stream.readByte();
        if ((this.cheststatus & 0x20) > 0) {
            this.blink = this.cheststatus & 0x20;
        }
        this.bdelay = 4;
        return oldorientation != this.orientation || oldcheststatus != this.cheststatus;
    }

    @Override
    public void configureTilePacket(DataOutputStream data) throws IOException {
        IMEInventoryHandler i;
        data.writeInt(this.priority);
        data.writeByte(this.getAERotationFromDirection(this.orientation));
        this.cheststatus = (byte)(this.cellinv.func_70301_a(0) != null ? 1 : 0);
        if (this.cheststatus > 0 && (i = AppEngCellRegistry.getCellHandler(this.cellinv.func_70301_a(0))) != null) {
            this.cheststatus = (byte)(this.cheststatus | (!i.isPreformatted() && i.canHoldNewItem() ? 4 : 0));
            this.cheststatus = (byte)(this.cheststatus | (i.remainingItemCount() > 0L ? 8 : 0));
            this.cheststatus = (byte)(this.cheststatus | (this.isMachineActive() ? 16 : 0));
            this.cheststatus = (byte)(this.cheststatus | (this.blink > 0 ? 32 : 0));
            this.blink = 0;
        }
        data.writeByte(this.cheststatus);
    }

    public int addItem(ItemStack stack, boolean doAdd, ForgeDirection from) {
        if (null == this.cellinv.func_70301_a(0)) {
            return 0;
        }
        ItemStack notUsed = null;
        IGridInterface gi = this.getGrid();
        IMEInventoryHandler mei = this.provideCell();
        if (mei != null) {
            if (this.buffer.func_70301_a(0) != null) {
                this.buffer.func_70299_a(0, Platform.addItems(mei, this.buffer.func_70301_a(0)));
            }
            if (doAdd) {
                notUsed = Platform.addItems(mei, stack);
                if (notUsed == null) {
                    return stack.field_77994_a;
                }
                return stack.field_77994_a - notUsed.field_77994_a;
            }
            notUsed = Platform.calculateItemAddition(mei, stack);
            if (notUsed == null) {
                return stack.field_77994_a;
            }
        } else {
            return 0;
        }
        return stack.field_77994_a - notUsed.field_77994_a;
    }

    public ItemStack[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        return new ItemStack[0];
    }

    @Override
    public String getName() {
        return "ME Chest";
    }

    @Override
    public boolean useMEEnergy(float use, String for_what) {
        if (AppEngConfiguration.allowLogging && AppEngConfiguration.logPowerUsage) {
            AppEng.log("Chest: " + use + " units for " + for_what);
        }
        return this.useMEEnergy(use);
    }

    public boolean useMEEnergy(float use) {
        if (!AppEngConfiguration.requirePower) {
            return true;
        }
        if (this.storedPower >= (use *= AppEngConfiguration.powerUsageMultiplier)) {
            this.storedPower -= use;
            return true;
        }
        this.storedPower = 0.0f;
        this.func_70296_d();
        return false;
    }

    @Override
    public int usePowerForAddition(int items, int multipler) {
        if (!AppEngConfiguration.requirePower) {
            return items;
        }
        int itemsCanAdd = 0;
        if (this.getGrid() != null) {
            itemsCanAdd += this.getGrid().usePowerForAddition(items, multipler);
        }
        if (itemsCanAdd < items) {
            int useablepower;
            itemsCanAdd = this.storedPower > (float)(items -= itemsCanAdd) ? (itemsCanAdd += this.useMEEnergy(items, "adding items to chest") ? items : 0) : (itemsCanAdd += this.useMEEnergy(useablepower = (int)Math.floor(this.storedPower), "adding items to chest") ? useablepower : 0);
        }
        return itemsCanAdd;
    }

    @Override
    protected int getMaxStoredPower() {
        return (int)this.maxStoredPower;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int p) {
        this.priority = p;
        if (this.getGrid() != null) {
            MinecraftForge.EVENT_BUS.post((Event)new GridStorageUpdateEvent(this.field_70331_k, this.getLocation(), this.getGrid()));
        }
    }

    @Override
    public void updateCellIndex(int idx) {
        this.blink = 32;
        this.markForUpdate();
    }

    public boolean func_94042_c() {
        return true;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        if (null == this.cellinv.func_70301_a(0)) {
            return false;
        }
        ItemStack notUsed = null;
        IGridInterface gi = this.getGrid();
        IMEInventoryHandler mei = this.provideCell();
        if (mei != null) {
            if (this.buffer.func_70301_a(0) != null) {
                this.buffer.func_70299_a(0, Platform.addItems(mei, this.buffer.func_70301_a(0)));
            }
            if ((notUsed = Platform.calculateItemAddition(mei, itemstack)) == null) {
                return true;
            }
        } else {
            return false;
        }
        return itemstack.field_77994_a - notUsed.field_77994_a != 0;
    }

    @Override
    public void notifyExtractItems(IAEItemStack removed) {
        IAEItemStack ns = removed.copy();
        ns.setStackSize(-ns.getStackSize());
        Platform.sumItemToList(this.invChanges, ns);
        this.triggerContainerUpdate();
    }

    @Override
    public void notifyAddItems(IAEItemStack added) {
        IAEItemStack ns = added.copy();
        Platform.sumItemToList(this.invChanges, ns);
        this.triggerContainerUpdate();
    }

    @Override
    public boolean isBlinking() {
        return this.blink != 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderBlinks(RenderBlocks rb) {
        if (this.blink == 0 && (this.cheststatus & 1) == 1 && (this.cheststatus & 0x10) > 0) {
            int x = this.field_70329_l;
            int y = this.field_70330_m;
            int z = this.field_70327_n;
            int bn = 15;
            float u = 6.0f;
            float v = 1.0f;
            if ((this.cheststatus & 0x10) > 0) {
                if ((this.cheststatus & 4) == 4) {
                    u = 1.0f;
                    v = 9.0f;
                } else if ((this.cheststatus & 8) == 8) {
                    u = 1.0f;
                    v = 5.0f;
                } else {
                    u = 1.0f;
                    v = 1.0f;
                }
            }
            Icon parts = AppEngTextureRegistry.Blocks.BlockHDChestTopParts.get();
            float offsetPerPixel = 0.0625f;
            float[] p1 = new float[5];
            float[] p2 = new float[5];
            float[] p3 = new float[5];
            float[] p4 = new float[5];
            p1[0] = 4.0f * offsetPerPixel;
            p1[1] = 0.991f;
            p1[2] = 4.0f * offsetPerPixel;
            p1[3] = u;
            p1[4] = v;
            p2[0] = p1[0] + offsetPerPixel * 4.0f;
            p2[1] = p1[1];
            p2[2] = p1[2];
            p2[3] = p1[3] + 4.0f;
            p2[4] = p1[4];
            p3[0] = p1[0] + offsetPerPixel * 4.0f;
            p3[1] = p1[1];
            p3[2] = p1[2] + offsetPerPixel * 3.0f;
            p3[3] = p1[3] + 4.0f;
            p3[4] = p1[4] + 3.0f;
            p4[0] = p1[0];
            p4[1] = p1[1];
            p4[2] = p1[2] + offsetPerPixel * 3.0f;
            p4[3] = p1[3];
            p4[4] = p1[4] + 3.0f;
            Tessellator tess = Tessellator.field_78398_a;
            tess.func_78380_c(bn << 20 | bn << 4);
            tess.func_78374_a((double)((float)x + p4[0]), (double)((float)y + p4[1]), (double)((float)z + p4[2]), (double)parts.func_94214_a((double)p4[3]), (double)parts.func_94207_b((double)p4[4]));
            tess.func_78374_a((double)((float)x + p3[0]), (double)((float)y + p3[1]), (double)((float)z + p3[2]), (double)parts.func_94214_a((double)p3[3]), (double)parts.func_94207_b((double)p3[4]));
            tess.func_78374_a((double)((float)x + p2[0]), (double)((float)y + p2[1]), (double)((float)z + p2[2]), (double)parts.func_94214_a((double)p2[3]), (double)parts.func_94207_b((double)p2[4]));
            tess.func_78374_a((double)((float)x + p1[0]), (double)((float)y + p1[1]), (double)((float)z + p1[2]), (double)parts.func_94214_a((double)p1[3]), (double)parts.func_94207_b((double)p1[4]));
        }
    }

    @Override
    public double drainMEPower(double amt) {
        return 0.0;
    }

    @Override
    public boolean isPublicPowerStorage() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.isCommonUseableByPlayer(entityplayer);
    }

    @Override
    public ForgeDirection getPrimaryOrientation() {
        return this.orientation;
    }

    @Override
    public int getSpin() {
        return 0;
    }

    @Override
    public void setPrimaryOrientation(ForgeDirection s) {
        this.orientation = s;
    }

    @Override
    public void setSpin(int spin) {
    }
}

