/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.item;

import appeng.api.WorldCoord;
import appeng.api.me.items.ISpatialStorage;
import appeng.api.me.util.TransitionResult;
import appeng.common.AppEngTextureRegistry;
import appeng.common.AppEngWorldSettings;
import appeng.common.base.AppEngMultiItem;
import appeng.common.base.AppEngSubItem;
import appeng.util.Platform;
import appeng.world.StorageHelper;
import appeng.world.StorageWorldProvider;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class ItemSpatialCell2
extends AppEngSubItem
implements ISpatialStorage {
    @Override
    public void addInformation(ItemStack i, EntityPlayer p, List l, boolean b) {
        l.add("Stores up to " + this.getMaxStoredDim(i) + " by " + this.getMaxStoredDim(i) + " by " + this.getMaxStoredDim(i));
    }

    public ItemSpatialCell2(AppEngMultiItem mi) {
        super(mi);
        this.unlocalizedName = "Spatial2Dim";
        this.myIcon = AppEngTextureRegistry.Items.Spatial2Dim;
    }

    @Override
    public boolean isSpatialStorage(ItemStack is) {
        return true;
    }

    @Override
    public int getMaxStoredDim(ItemStack is) {
        return 2;
    }

    @Override
    public World getWorld(ItemStack is) {
        if (is.func_77942_o()) {
            NBTTagCompound c = is.func_77978_p();
            int dim = c.func_74762_e("StorageDim");
            WorldServer w = DimensionManager.getWorld((int)dim);
            if (w == null) {
                DimensionManager.initDimension((int)dim);
                w = DimensionManager.getWorld((int)dim);
            }
            if (w != null && w.field_73011_w instanceof StorageWorldProvider) {
                return w;
            }
        }
        return null;
    }

    private void setStoredSize(ItemStack is, int targetX, int targetY, int targetZ) {
        if (is.func_77942_o()) {
            NBTTagCompound c = is.func_77978_p();
            int dim = c.func_74762_e("StorageDim");
            AppEngWorldSettings.getInstance().setStoredSize(dim, targetX, targetY, targetZ);
        }
    }

    @Override
    public WorldCoord getStoredSize(ItemStack is) {
        if (is.func_77942_o()) {
            NBTTagCompound c = is.func_77978_p();
            int dim = c.func_74762_e("StorageDim");
            return AppEngWorldSettings.getInstance().getStoredSize(dim);
        }
        return new WorldCoord(0, 0, 0);
    }

    @Override
    public WorldCoord getMin(ItemStack is) {
        NBTTagCompound info;
        World w = this.getWorld(is);
        if (w != null && (info = (NBTTagCompound)w.func_72912_H().getAdditionalProperty("storageCell")) != null) {
            return new WorldCoord(info.func_74762_e("minX"), info.func_74762_e("minY"), info.func_74762_e("minZ"));
        }
        return new WorldCoord(0, 0, 0);
    }

    @Override
    public WorldCoord getMax(ItemStack is) {
        NBTTagCompound info;
        World w = this.getWorld(is);
        if (w != null && (info = (NBTTagCompound)w.func_72912_H().getAdditionalProperty("storageCell")) != null) {
            return new WorldCoord(info.func_74762_e("maxX"), info.func_74762_e("maxY"), info.func_74762_e("maxZ"));
        }
        return new WorldCoord(0, 0, 0);
    }

    @Override
    public World createNewWorld(ItemStack is) {
        NBTTagCompound c = Platform.openNbtData(is);
        int newDim = DimensionManager.getNextFreeDimId();
        c.func_74768_a("StorageDim", newDim);
        AppEngWorldSettings.getInstance().addStorageCellDim(newDim);
        DimensionManager.initDimension((int)newDim);
        return DimensionManager.getWorld((int)newDim);
    }

    @Override
    public TransitionResult doSpatialTransition(ItemStack is, World w, WorldCoord min, WorldCoord max, boolean doTransition) {
        WorldCoord scale = this.getStoredSize(is);
        int targetX = max.x - min.x - 1;
        int targetY = max.y - min.y - 1;
        int targetZ = max.z - min.z - 1;
        int maxSize = 99999;
        World dest = this.getWorld(is);
        if ((scale.x == 0 && scale.y == 0 && scale.z == 0 || scale.x == targetX && scale.y == targetY && scale.z == targetZ) && targetX <= maxSize && targetY <= maxSize && targetZ <= maxSize) {
            if (dest == null) {
                dest = this.createNewWorld(is);
            }
            StorageHelper.getInstance().swapRegions(w, dest, min.x + 1, min.y + 1, min.z + 1, 1, 1, 1, targetX - 1, targetY - 1, targetZ - 1);
            this.setStoredSize(is, targetX, targetY, targetZ);
            return new TransitionResult(true, 0.0);
        }
        return new TransitionResult(false, 0.0);
    }
}

