/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.block;

import appeng.api.Blocks;
import appeng.common.AppEngTextureRegistry;
import appeng.common.base.AppEngMultiBlock;
import appeng.common.base.AppEngSubBlock;
import appeng.interfaces.IDismantleable;
import appeng.me.tile.TileEnergyCell;
import appeng.util.Platform;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.World;

public class BlockEnergyCell
extends AppEngSubBlock
implements IDismantleable {
    public BlockEnergyCell(AppEngMultiBlock mb) {
        super(mb, true);
        this.unlocalizedName = "EnergyCell";
    }

    @Override
    public boolean hasTileEntity() {
        return true;
    }

    @Override
    public void onBlockDismantle(World w, int x, int y, int z, EntityPlayer player, int side) {
        TileEntity te = w.func_72796_p(x, y, z);
        int id = w.func_72798_a(x, y, z);
        if (te instanceof TileEnergyCell) {
            TileEnergyCell tec = (TileEnergyCell)te;
            ItemStack stk = Blocks.blkEnergyCell.func_77946_l();
            if (tec.getMECurrentPower() > 0.9) {
                NBTTagCompound c = Platform.openNbtData(stk);
                c.func_74768_a("storedEnergy", (int)tec.getMECurrentPower());
            }
            if (Block.field_71973_m[id].removeBlockByPlayer(w, player, x, y, z)) {
                ArrayList<ItemStack> l = new ArrayList<ItemStack>();
                l.add(stk);
                Platform.spawnDrops(w, x, y, z, l);
                w.func_94571_i(x, y, z);
            }
        } else {
            super.onBlockDismantle(w, x, y, z, player, side);
        }
    }

    @Override
    public Icon getBlockTextureFromSide(int side) {
        return AppEngTextureRegistry.Blocks.MEEnergyCell[0].get();
    }

    @Override
    public TileEntity createNewTileEntity(World w) {
        return new TileEnergyCell();
    }

    @Override
    public void getSubBlocks(List subItems) {
        ItemStack mbs = new ItemStack((Block)this.imb, 1, this.metaData);
        subItems.add(mbs);
        NBTTagCompound power = new NBTTagCompound();
        power.func_74768_a("storedEnergy", 200000);
        mbs = new ItemStack((Block)this.imb, 1, this.metaData);
        mbs.func_77982_d(power);
        subItems.add(mbs);
    }

    @Override
    public boolean isOpaqueCube() {
        return true;
    }
}

