/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.block;

import appeng.api.me.tiles.IColoredMETile;
import appeng.common.AppEngTextureRegistry;
import appeng.common.base.AppEngMultiBlock;
import appeng.me.block.BlockCableBase;
import appeng.me.tile.TileCable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class BlockCable
extends BlockCableBase
implements IColoredMETile {
    int cableOffset = 0;

    @Override
    public int getLightOpacity() {
        return 1;
    }

    public BlockCable(AppEngMultiBlock mb, int colorOffset) {
        super(mb, true);
        this.cableOffset = colorOffset;
        this.unlocalizedName = "Cable";
    }

    @Override
    public void onNeighborBlockChange(World w, int x, int y, int z, int blockid) {
        super.onNeighborBlockChange(w, x, y, z, blockid);
        w.func_72845_h(x, y, z);
    }

    @Override
    public TileEntity createNewTileEntity(World w) {
        return new TileCable(this.cableOffset);
    }

    @Override
    public boolean hasTileEntity() {
        return true;
    }

    @Override
    public Icon getBlockTextureFromSide(int side) {
        return AppEngTextureRegistry.Blocks.MECableColors[this.cableOffset].get();
    }

    @Override
    public void setColor(int offset) {
        this.cableOffset = offset;
    }

    @Override
    public int getColor() {
        return this.cableOffset;
    }

    @Override
    public boolean isColored(ForgeDirection d) {
        return true;
    }
}

