/*
 * Decompiled with CFR 0.152.
 */
package appeng.common.registries;

import appeng.api.IWirelessTermHandler;
import appeng.api.IWirelessTermRegistery;
import appeng.common.AppEng;
import appeng.common.AppEngConfiguration;
import appeng.common.registries.WirelessRangeResult;
import appeng.gui.AppEngGuiHandler;
import appeng.me.tile.TileController;
import appeng.util.Platform;
import cpw.mods.fml.common.network.Player;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class AppEngWirelessRegistry
implements IWirelessTermRegistery {
    List<IWirelessTermHandler> handlers = new ArrayList<IWirelessTermHandler>();

    @Override
    public void registerWirelessHandler(IWirelessTermHandler handler) {
        this.handlers.add(handler);
    }

    @Override
    public boolean isWirelessTerminal(ItemStack is) {
        for (IWirelessTermHandler h : this.handlers) {
            if (!h.canHandle(is)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IWirelessTermHandler getWirelessTerminalHandler(ItemStack is) {
        for (IWirelessTermHandler h : this.handlers) {
            if (!h.canHandle(is)) continue;
            return h;
        }
        return null;
    }

    @Override
    public void OpenWirelessTermainlGui(ItemStack item, World w, EntityPlayer player) {
        if (Platform.isClient()) {
            return;
        }
        IWirelessTermHandler handler = this.getWirelessTerminalHandler(item);
        if (handler == null) {
            player.func_71035_c("Item is not a wireless terminal.");
            return;
        }
        if (handler.usePower((Player)player, 10.0f, item)) {
            String encKey = handler.getEncryptionKey(item);
            if (encKey == null || encKey == "") {
                Platform.LocalizedChatMsg("ChatMsg.TermNotLinked", player);
                return;
            }
            Object target = AppEng.getApiInstance().getLocateableRegistry().findLocateableBySerial(Long.valueOf(encKey));
            if (target != null && target instanceof TileController) {
                TileController tc = (TileController)target;
                if (tc.EncryptionKey.compareTo(encKey) == 0) {
                    WirelessRangeResult wrr = tc.inWirelessRange(player);
                    if (wrr.dist >= 0.0f) {
                        if (handler.usePower((Player)player, (float)(AppEngConfiguration.WirelessDistanceMultiplier / 100.0 * 10.0 * (double)((float)Math.sqrt(wrr.dist))), item)) {
                            Platform.openGui(player, AppEngGuiHandler.GUI_WTERMINAL, player.field_70170_p, wrr.te.field_70329_l, wrr.te.field_70330_m, wrr.te.field_70327_n);
                            tc.addViewingPlayer(player);
                            return;
                        }
                        Platform.LocalizedChatMsg("ChatMsg.TermNoPower", player);
                        return;
                    }
                }
            }
            Platform.LocalizedChatMsg("ChatMsg.TermNoSignal", player);
        } else {
            Platform.LocalizedChatMsg("ChatMsg.TermNoPower", player);
        }
    }
}

