/*
 * Decompiled with CFR 0.152.
 */
package codechicken.translocator;

import codechicken.lib.inventory.InventoryUtils;
import codechicken.lib.math.MathHelper;
import codechicken.lib.packet.ICustomPacketTile;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import codechicken.translocator.TranslocatorSPH;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public abstract class TileTranslocator
extends asp
implements ICustomPacketTile {
    public Attachment[] attachments = new Attachment[6];

    public void h() {
        for (Attachment a : this.attachments) {
            if (a == null) continue;
            a.update(this.k.I);
        }
    }

    public ey m() {
        PacketCustom packet = new PacketCustom(TranslocatorSPH.channel, 1);
        packet.setChunkDataPacket();
        packet.writeCoord(this.l, this.m, this.n);
        int attachmask = 0;
        for (int i = 0; i < 6; ++i) {
            if (this.attachments[i] == null) continue;
            attachmask |= 1 << i;
        }
        packet.writeByte(attachmask);
        for (Attachment a : this.attachments) {
            if (a == null) continue;
            a.write(packet);
        }
        return packet.toPacket();
    }

    public void handleDescriptionPacket(PacketCustom packet) {
        if (packet.getType() == 1) {
            int attachmask = packet.readUByte();
            for (int i = 0; i < 6; ++i) {
                if ((attachmask & 1 << i) != 0) {
                    boolean described;
                    boolean bl = described = this.attachments[i] != null;
                    if (!described) {
                        this.createAttachment(i);
                    }
                    this.attachments[i].read(packet, described);
                    continue;
                }
                this.attachments[i] = null;
            }
            this.k.p(this.l, this.m, this.n);
        }
    }

    public void createAttachment(int side) {
        this.attachments[side] = new Attachment(side);
    }

    public void b(by tag) {
        super.b(tag);
        for (int i = 0; i < 6; ++i) {
            if (this.attachments[i] == null) continue;
            tag.a("atmt" + i, this.attachments[i].write(new by()));
        }
    }

    public void a(by tag) {
        super.a(tag);
        for (int i = 0; i < 6; ++i) {
            if (!tag.b("atmt" + i)) continue;
            this.createAttachment(i);
            this.attachments[i].read(tag.l("atmt" + i));
        }
    }

    public void addTraceableCuboids(List<IndexedCuboid6> cuboids) {
        Vector3 pos = Vector3.fromTileEntity((asp)this);
        Cuboid6 base = new Cuboid6(0.1875, 0.0, 0.1875, 0.8125, 0.125, 0.8125);
        for (int i = 0; i < 6; ++i) {
            Attachment a = this.attachments[i];
            if (a == null) continue;
            cuboids.add(new IndexedCuboid6((Object)i, this.transformPart(base, pos, i)));
            cuboids.add(new IndexedCuboid6((Object)(i + 6), this.transformPart(new Cuboid6(0.375, 0.0, 0.375, 0.625, a.a_insertpos * 2.0 / 16.0 + 0.0625, 0.625), pos, i)));
        }
    }

    private Cuboid6 transformPart(Cuboid6 box, Vector3 pos, int i) {
        return box.copy().apply(Rotation.sideRotations[i].at(Vector3.center)).add(pos);
    }

    public asx getRenderBoundingBox() {
        return asx.a((double)this.l, (double)this.m, (double)this.n, (double)(this.l + 1), (double)(this.m + 1), (double)(this.n + 1));
    }

    public boolean harvestPart(int i, boolean drop) {
        Attachment a = this.attachments[i];
        if (!this.k.I && drop) {
            for (ye stack : a.getDrops()) {
                this.dropItem(stack);
            }
        }
        this.attachments[i] = null;
        this.k.j(this.l, this.m, this.n);
        for (Attachment a1 : this.attachments) {
            if (a1 == null) continue;
            return false;
        }
        this.k.i(this.l, this.m, this.n);
        return true;
    }

    public void dropItem(ye stack) {
        InventoryUtils.dropItem((ye)stack, (abw)this.k, (Vector3)Vector3.fromTileEntityCenter((asp)this));
    }

    public boolean gettingPowered() {
        return this.k.C(this.l, this.m, this.n);
    }

    public boolean connectRedstone() {
        for (Attachment a : this.attachments) {
            if (a == null || !a.redstone) continue;
            return true;
        }
        return false;
    }

    public int strongPowerLevel(int side) {
        return 0;
    }

    public class Attachment {
        public final int side;
        public boolean a_eject;
        public boolean b_eject;
        public boolean redstone;
        public boolean invert_redstone;
        public boolean fast;
        public double a_insertpos;
        public double b_insertpos;

        public Attachment(int side) {
            this.side = side;
            this.invert_redstone = true;
            this.b_eject = true;
            this.a_eject = true;
            this.b_insertpos = 1.0;
            this.a_insertpos = 1.0;
        }

        public void read(by tag) {
            this.invert_redstone = tag.n("invert_redstone");
            this.redstone = tag.n("redstone");
            this.fast = tag.n("fast");
        }

        public void update(boolean client) {
            this.b_insertpos = this.a_insertpos;
            this.a_insertpos = MathHelper.approachExp((double)this.a_insertpos, (double)this.approachInsertPos(), (double)0.5, (double)0.1);
            if (!client) {
                this.b_eject = this.a_eject;
                boolean bl = this.a_eject = (this.redstone && TileTranslocator.this.gettingPowered()) != this.invert_redstone;
                if (this.a_eject != this.b_eject) {
                    this.markUpdate();
                }
            }
        }

        public double approachInsertPos() {
            return this.a_eject ? 1.0 : 0.0;
        }

        public void write(PacketCustom packet) {
            packet.writeBoolean(this.a_eject);
            packet.writeBoolean(this.redstone);
            packet.writeBoolean(this.fast);
        }

        public void read(PacketCustom packet, boolean described) {
            this.a_eject = packet.readBoolean();
            this.redstone = packet.readBoolean();
            this.fast = packet.readBoolean();
            if (!described) {
                this.a_insertpos = this.b_insertpos = this.approachInsertPos();
            }
        }

        public by write(by tag) {
            tag.a("invert_redstone", this.invert_redstone);
            tag.a("redstone", this.redstone);
            tag.a("fast", this.fast);
            return tag;
        }

        public boolean activate(uf player, int subPart) {
            ye held = player.bn.h();
            if (held == null && player.ah()) {
                this.stripModifiers();
                this.markUpdate();
            } else if (held == null) {
                if (subPart == 1) {
                    this.invert_redstone = !this.invert_redstone;
                } else {
                    this.openGui(player);
                }
            } else if (held.b() == yc.aE && !this.redstone) {
                this.redstone = true;
                if (!player.bG.d) {
                    --held.b;
                }
                if (TileTranslocator.this.gettingPowered() != this.invert_redstone != this.a_eject) {
                    this.invert_redstone = !this.invert_redstone;
                }
                this.markUpdate();
            } else if (held.b() == yc.aV && !this.fast) {
                this.fast = true;
                if (!player.bG.d) {
                    --held.b;
                }
                this.markUpdate();
            } else {
                this.openGui(player);
            }
            return true;
        }

        public void stripModifiers() {
            if (this.redstone) {
                this.redstone = false;
                TileTranslocator.this.dropItem(new ye(yc.aE));
                if (this.invert_redstone != this.a_eject) {
                    boolean bl = this.invert_redstone = !this.invert_redstone;
                }
            }
            if (this.fast) {
                this.fast = false;
                TileTranslocator.this.dropItem(new ye(yc.aV));
            }
        }

        public void openGui(uf player) {
        }

        public void markUpdate() {
            TileTranslocator.this.k.j(TileTranslocator.this.l, TileTranslocator.this.m, TileTranslocator.this.n);
            TileTranslocator.this.e();
        }

        public Collection<ye> getDrops() {
            LinkedList<ye> items = new LinkedList<ye>();
            items.add(new ye(TileTranslocator.this.q(), 1, TileTranslocator.this.p()));
            if (this.redstone) {
                items.add(new ye(yc.aE));
            }
            if (this.fast) {
                items.add(new ye(yc.aV));
            }
            return items;
        }

        public int getIconIndex() {
            int i = 0;
            if (this.redstone) {
                i |= TileTranslocator.this.gettingPowered() ? 2 : 1;
            }
            if (this.fast) {
                i |= 4;
            }
            return i;
        }
    }
}

