/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.util;

import com.google.common.base.Strings;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import openmods.Log;

public class PeripheralUtils {
    private static Map<String, Class<? extends TileEntity>> teNameToClass;
    private static Map<Class<? extends TileEntity>, String> teClassToName;

    public static Map<Class<? extends TileEntity>, String> getClassToNameMap() {
        if (teClassToName == null) {
            teClassToName = (Map)ReflectionHelper.getPrivateValue(TileEntity.class, null, (String[])new String[]{"classToNameMap", "field_70323_b"});
        }
        return teClassToName;
    }

    public static Map<String, Class<? extends TileEntity>> getNameToClassMap() {
        if (teNameToClass == null) {
            teNameToClass = (Map)ReflectionHelper.getPrivateValue(TileEntity.class, null, (String[])new String[]{"nameToClassMap", "field_70326_a"});
        }
        return teNameToClass;
    }

    public static String getNameForTarget(Object target) {
        String name = PeripheralUtils.tryGetName(target);
        return Strings.isNullOrEmpty((String)name) ? "peripheral" : name.replaceAll("[^a-zA-Z0-9]", "_").toLowerCase();
    }

    private static String tryGetName(Object target) {
        if (target == null) {
            return "";
        }
        if (target instanceof IInventory) {
            try {
                return ((IInventory)target).func_70303_b();
            }
            catch (Throwable t) {
                Log.warn((Throwable)t, (String)"Can't get inventory name for %s", (Object[])new Object[]{target.getClass()});
            }
        }
        if (target instanceof TileEntity) {
            TileEntity te = (TileEntity)target;
            String name = PeripheralUtils.getClassToNameMap().get(te.getClass());
            if (!Strings.isNullOrEmpty((String)name)) {
                return name;
            }
            try {
                Block block = te.func_70311_o();
                if (block != null) {
                    int dmg = te.func_70322_n();
                    ItemStack is = new ItemStack(block, 1, dmg);
                    try {
                        return is.func_82833_r();
                    }
                    catch (Throwable t) {
                        Log.warn((Throwable)t, (String)"Can't get display name for %s", (Object[])new Object[]{target.getClass()});
                        try {
                            return is.func_77977_a();
                        }
                        catch (Throwable t2) {
                            Log.warn((Throwable)t2, (String)"Can't get unlocalized name for %s", (Object[])new Object[]{target.getClass()});
                        }
                    }
                }
            }
            catch (Throwable t) {
                Log.warn((Throwable)t, (String)"Exception while getting name from item for %s", (Object[])new Object[]{target.getClass()});
            }
            if (Strings.isNullOrEmpty((String)name)) {
                String string = te.getClass().getSimpleName();
            }
        }
        return "";
    }
}

