/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.util;

import com.google.common.base.Objects;
import com.google.common.base.Throwables;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import openperipheral.adapter.IAdapterMethodsList;
import openperipheral.adapter.IDescriptable;
import openperipheral.adapter.IMethodExecutor;
import openperipheral.adapter.IMethodsHolder;
import openperipheral.adapter.composed.ClassMethodsList;
import openperipheral.util.PeripheralUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DocBuilder {
    private final Document doc;
    private final Element root;

    public DocBuilder() {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            this.doc = docBuilder.newDocument();
            this.root = this.doc.createElement("documentation");
            this.doc.appendChild(this.root);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void dump(File output) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(this.doc);
            StreamResult result = new StreamResult(output);
            transformer.transform(source, result);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void createDocForPeripheral(String type, IAdapterMethodsList<?> methods) {
        Element result = this.doc.createElement(type);
        result.setAttribute("targetClass", methods.getTargetClass().toString());
        this.fillMethods(result, methods);
        this.root.appendChild(result);
    }

    public void createDocForTe(Class<?> cls, ClassMethodsList<?> list) {
        if (!list.hasMethods) {
            return;
        }
        Element result = this.doc.createElement("tileEntity");
        this.fillDocForClassList(result, cls, list);
        String teName = (String)Objects.firstNonNull((Object)PeripheralUtils.getClassToNameMap().get(cls), (Object)"null");
        result.appendChild(this.createProperty("name", teName));
        this.root.appendChild(result);
    }

    public void createDocForObject(Class<?> cls, ClassMethodsList<?> list) {
        if (!list.hasMethods) {
            return;
        }
        Element result = this.doc.createElement("luaObject");
        this.fillDocForClassList(result, cls, list);
        this.root.appendChild(result);
    }

    private void fillDocForClassList(Element result, Class<?> cls, ClassMethodsList<?> list) {
        result.setAttribute("class", cls.getName());
        result.appendChild(this.createProperty("simpleName", cls.getSimpleName()));
        this.fillMethods(result, list);
    }

    protected void fillMethods(Element result, IMethodsHolder<?> holder) {
        for (IMethodExecutor method : holder.listMethods()) {
            if (method.isSynthetic()) continue;
            Element methodDoc = this.doc.createElement("method");
            this.fillDocForMethod(methodDoc, method.getWrappedMethod());
            result.appendChild(methodDoc);
        }
    }

    private void fillDocForMethod(Element result, IDescriptable method) {
        for (String name : method.getNames()) {
            result.appendChild(this.createProperty("name", name));
        }
        result.appendChild(this.createProperty("signature", method.signature()));
        Element description = this.doc.createElement("extra");
        this.serializeMap(description, method.describe());
        result.appendChild(description);
    }

    private void serializeValue(Element output, Object value) {
        if (value == null) {
            output.appendChild(this.doc.createTextNode("null"));
        } else if (value instanceof Map) {
            this.serializeMap(output, (Map)value);
        } else if (value instanceof Collection) {
            this.serializeCollection(output, (Collection)value);
        } else {
            output.appendChild(this.doc.createTextNode(value.toString()));
        }
    }

    private void serializeCollection(Element output, Collection<?> list) {
        int index = 0;
        for (Object o : list) {
            Element e = this.doc.createElement("e");
            e.setAttribute("index", Integer.toString(index++));
            this.serializeValue(e, o);
            output.appendChild(e);
        }
    }

    private void serializeMap(Element output, Map<?, ?> map) {
        for (Map.Entry<?, ?> e : map.entrySet()) {
            Object key = e.getKey();
            Element entry = this.doc.createElement(key == null ? "null" : key.toString());
            this.serializeValue(entry, e.getValue());
            output.appendChild(entry);
        }
    }

    private Element createProperty(String tag, String value) {
        Element el = this.doc.createElement(tag);
        el.appendChild(this.doc.createTextNode(value));
        return el;
    }
}

