/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.vanilla;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumMovingObjectType;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import openmods.utils.ReflectionHelper;
import openperipheral.adapter.AdapterManager;
import openperipheral.api.IIntegrationModule;
import openperipheral.integration.vanilla.AdapterBeacon;
import openperipheral.integration.vanilla.AdapterBrewingStand;
import openperipheral.integration.vanilla.AdapterComparator;
import openperipheral.integration.vanilla.AdapterDaylightSensor;
import openperipheral.integration.vanilla.AdapterFluidHandler;
import openperipheral.integration.vanilla.AdapterFluidTank;
import openperipheral.integration.vanilla.AdapterFurnace;
import openperipheral.integration.vanilla.AdapterInventory;
import openperipheral.integration.vanilla.AdapterMobSpawner;
import openperipheral.integration.vanilla.AdapterNoteBlock;
import openperipheral.integration.vanilla.AdapterRecordPlayer;
import openperipheral.integration.vanilla.AdapterSign;
import openperipheral.util.InventoryDescriptionUtils;

public class ModuleVanilla
implements IIntegrationModule {
    public static String DUMMY_VANILLA_MODID = "vanilla";

    @Override
    public String getModId() {
        return DUMMY_VANILLA_MODID;
    }

    @Override
    public void init() {
        AdapterManager.addPeripheralAdapter(new AdapterInventory());
        AdapterManager.addPeripheralAdapter(new AdapterNoteBlock());
        AdapterManager.addPeripheralAdapter(new AdapterComparator());
        AdapterManager.addPeripheralAdapter(new AdapterBeacon());
        AdapterManager.addPeripheralAdapter(new AdapterBrewingStand());
        AdapterManager.addPeripheralAdapter(new AdapterFluidHandler());
        AdapterManager.addPeripheralAdapter(new AdapterFluidTank());
        AdapterManager.addPeripheralAdapter(new AdapterFurnace());
        AdapterManager.addPeripheralAdapter(new AdapterMobSpawner());
        AdapterManager.addPeripheralAdapter(new AdapterRecordPlayer());
        AdapterManager.addPeripheralAdapter(new AdapterSign());
        AdapterManager.addPeripheralAdapter(new AdapterDaylightSensor());
    }

    @Override
    public void appendEntityInfo(Map<String, Object> map, Entity entity, Vec3 relativePos) {
        if (entity instanceof IInventory) {
            map.put("inventory", InventoryDescriptionUtils.invToMap((IInventory)entity));
        }
        if (entity instanceof EntityHorse) {
            EntityHorse horse = (EntityHorse)entity;
            IInventory invent = (IInventory)ReflectionHelper.getProperty((String)"", (Object)horse, (String[])new String[]{"field_110296_bG"});
            map.put("eatingHaystack", horse.func_110204_cc());
            map.put("chestedHorse", horse.func_110261_ca());
            map.put("hasReproduced", horse.func_110243_cf());
            map.put("bred", horse.func_110205_ce());
            map.put("horseType", horse.func_110265_bP());
            map.put("horseVariant", horse.func_110202_bQ());
            map.put("horseTemper", horse.func_110252_cg());
            map.put("horseTame", horse.func_110248_bS());
            map.put("ownerName", horse.func_142019_cb());
            map.put("horseInventory", InventoryDescriptionUtils.invToMap(invent));
        }
        if (entity instanceof EntityVillager) {
            EntityVillager villager = (EntityVillager)entity;
            map.put("profession", villager.func_70946_n());
            map.put("isMating", villager.func_70941_o());
            map.put("isPlaying", villager.func_70945_p());
            boolean isTrading = villager.func_70940_q();
            map.put("isTrading", isTrading);
            if (isTrading) {
                map.put("customer", villager.func_70931_l_().field_71092_bJ);
            }
        }
        if (entity instanceof EntitySheep) {
            EntitySheep sheep = (EntitySheep)entity;
            map.put("sheepColor", sheep.func_70896_n());
            map.put("isSheared", sheep.func_70892_o());
        }
        if (entity instanceof EntityZombie) {
            EntityZombie zombie = (EntityZombie)entity;
            map.put("isVillagerZombie", zombie.func_82231_m());
            map.put("convertingToVillager", zombie.func_82230_o());
        }
        if (entity instanceof EntityBat) {
            EntityBat bat = (EntityBat)entity;
            map.put("isHanging", bat.func_82235_h());
        }
        if (entity instanceof EntityPig) {
            EntityPig pig = (EntityPig)entity;
            map.put("isSaddled", pig.func_70901_n());
        }
        if (entity instanceof EntityWolf) {
            EntityWolf wolf = (EntityWolf)entity;
            map.put("isShaking", wolf.func_70921_u());
            map.put("isAngry", wolf.func_70919_bu());
            map.put("collarColor", Math.pow(2.0, wolf.func_82186_bH()));
        }
        if (entity instanceof EntityTameable) {
            EntityTameable mob = (EntityTameable)entity;
            boolean isTamed = mob.func_70909_n();
            map.put("isTamed", isTamed);
            if (isTamed) {
                map.put("isSitting", mob.func_70906_o());
                map.put("owner", mob.func_70905_p());
            }
        }
        if (entity instanceof EntityCreeper) {
            EntityCreeper creeper = (EntityCreeper)entity;
            map.put("isCharged", creeper.func_70830_n());
        }
        if (entity instanceof EntityWitch) {
            EntityWitch witch = (EntityWitch)entity;
            map.put("isAggressive", witch.func_82198_m());
        }
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase living = (EntityLivingBase)entity;
            HashMap<String, Map<String, Object>> armor = new HashMap<String, Map<String, Object>>();
            map.put("armor", armor);
            HashMap<Integer, String> potionEffects = new HashMap<Integer, String>();
            map.put("potionEffects", potionEffects);
            armor.put("boots", InventoryDescriptionUtils.itemstackToMap(living.func_71124_b(1)));
            armor.put("leggings", InventoryDescriptionUtils.itemstackToMap(living.func_71124_b(2)));
            armor.put("chestplate", InventoryDescriptionUtils.itemstackToMap(living.func_71124_b(3)));
            armor.put("helmet", InventoryDescriptionUtils.itemstackToMap(living.func_71124_b(4)));
            map.put("health", Float.valueOf(living.func_110143_aJ()));
            map.put("maxHealth", Float.valueOf(living.func_110138_aP()));
            map.put("isAirborne", living.field_70160_al);
            map.put("isBurning", living.func_70027_ad());
            map.put("isAlive", living.func_70089_S());
            map.put("isInWater", living.func_70090_H());
            map.put("isOnLadder", living.func_70617_f_());
            map.put("isSleeping", living.func_70608_bn());
            map.put("isRiding", living.func_70115_ae());
            map.put("isSneaking", living.func_70093_af());
            map.put("isSprinting", living.func_70051_ag());
            map.put("isWet", living.func_70026_G());
            map.put("isChild", living.func_70631_g_());
            map.put("isDead", living.field_70128_L);
            map.put("yaw", Float.valueOf(living.field_70177_z));
            map.put("pitch", Float.valueOf(living.field_70125_A));
            map.put("yawHead", Float.valueOf(living.field_70759_as));
            map.put("heldItem", InventoryDescriptionUtils.itemstackToMap(living.func_70694_bm()));
            Collection effects = living.func_70651_bq();
            int count = 1;
            for (PotionEffect effect : effects) {
                potionEffects.put(count++, effect.func_76453_d());
            }
            Vec3 posVec = living.field_70170_p.func_82732_R().func_72345_a(living.field_70165_t, living.field_70163_u + (double)1.62f, living.field_70161_v);
            Vec3 lookVec = living.func_70676_i(1.0f);
            Vec3 targetVec = posVec.func_72441_c(lookVec.field_72450_a * 10.0, lookVec.field_72448_b * 10.0, lookVec.field_72449_c * 10.0);
            MovingObjectPosition mop = living.field_70170_p.func_72933_a(posVec, targetVec);
            map.put("IsLookingAtBlock", false);
            if (mop != null) {
                map.put("IsLookingAtBlock", mop.field_72313_a == EnumMovingObjectType.TILE);
                if (mop.field_72313_a == EnumMovingObjectType.TILE) {
                    HashMap<String, Number> lookingAt = new HashMap<String, Number>();
                    if (relativePos != null) {
                        lookingAt.put("x", (double)mop.field_72311_b - relativePos.field_72450_a);
                        lookingAt.put("y", (double)mop.field_72312_c - relativePos.field_72448_b);
                        lookingAt.put("z", (double)mop.field_72309_d - relativePos.field_72449_c);
                    } else {
                        lookingAt.put("x", mop.field_72311_b);
                        lookingAt.put("y", mop.field_72312_c);
                        lookingAt.put("z", mop.field_72309_d);
                    }
                    map.put("lookingAt", lookingAt);
                } else {
                    map.put("lookingAt", null);
                }
            }
        }
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            map.put("type", "Player");
            map.put("inventory", InventoryDescriptionUtils.invToMap((IInventory)player.field_71071_by));
            map.put("isAirBorne", player.field_70160_al);
            map.put("isBlocking", player.func_70632_aY());
            map.put("username", player.field_71092_bJ);
            map.put("foodLevel", player.func_71024_bL().func_75116_a());
            map.put("isCreativeMode", player.field_71075_bZ.field_75098_d);
        }
    }

    @Override
    public void appendItemInfo(Map<String, Object> map, ItemStack itemstack) {
        Map<Integer, Object> ench = ModuleVanilla.getBookEnchantments(itemstack);
        if (ench != null) {
            map.put("ench", ench);
        }
    }

    private static Map<Integer, Object> getBookEnchantments(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof ItemEnchantedBook) {
            NBTTagList ench = Item.field_92105_bW.func_92110_g(stack);
            return ModuleVanilla.createEnchantmentList(ench);
        }
        NBTTagList ench = stack.func_77986_q();
        return ModuleVanilla.createEnchantmentList(ench);
    }

    private static Map<Integer, Object> createEnchantmentList(NBTTagList ench) {
        HashMap response = Maps.newHashMap();
        int offset = 1;
        if (ench != null) {
            for (int i = 0; i < ench.func_74745_c(); ++i) {
                NBTTagCompound enchTag = (NBTTagCompound)ench.func_74743_b(i);
                short id = enchTag.func_74765_d("id");
                short lvl = enchTag.func_74765_d("lvl");
                if (Enchantment.field_77331_b[id] == null) continue;
                response.put(offset, Enchantment.field_77331_b[id].func_77316_c((int)lvl));
                ++offset;
            }
        }
        return response;
    }
}

