/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.vanilla;

import com.google.common.base.Preconditions;
import net.minecraft.tileentity.TileEntitySign;
import openperipheral.api.Arg;
import openperipheral.api.IPeripheralAdapter;
import openperipheral.api.LuaMethod;
import openperipheral.api.LuaType;
import org.apache.commons.lang3.StringUtils;

public class AdapterSign
implements IPeripheralAdapter {
    @Override
    public Class<?> getTargetClass() {
        return TileEntitySign.class;
    }

    private static void checkRange(int value, int max) {
        Preconditions.checkArgument((value >= 0 && value < max ? 1 : 0) != 0, (String)"Value must be in range [1,%s]", (Object[])new Object[]{max});
    }

    @LuaMethod(returnType=LuaType.VOID, description="Sets the text on the sign", args={@Arg(name="line", type=LuaType.NUMBER, description="The line number to set the text on the sign"), @Arg(name="text", type=LuaType.STRING, description="The text to display on the sign")})
    public void setLine(TileEntitySign sign, int line, String text) {
        AdapterSign.checkRange(--line, sign.field_70412_a.length);
        sign.field_70412_a[line] = text.length() < 15 ? text : text.substring(0, 15);
        sign.field_70331_k.func_72845_h(sign.field_70329_l, sign.field_70330_m, sign.field_70327_n);
    }

    @LuaMethod(returnType=LuaType.STRING, onTick=false, description="Gets the text from the supplied line of the sign", args={@Arg(name="line", type=LuaType.NUMBER, description="The line number to get from the sign")})
    public String getLine(TileEntitySign sign, int line) {
        AdapterSign.checkRange(--line, sign.field_70412_a.length);
        return sign.field_70412_a[line];
    }

    @LuaMethod(returnType=LuaType.VOID, description="Sets the text on the sign", args={@Arg(name="text", type=LuaType.STRING, description="The text to display on the sign")})
    public void setText(TileEntitySign sign, String text) {
        String[] lines = text.split("\n");
        int currLength = lines.length;
        int maxLength = sign.field_70412_a.length;
        AdapterSign.checkRange(currLength, maxLength);
        for (int i = 0; i < maxLength; ++i) {
            this.setLine(sign, i + 1, i < currLength ? lines[i] : "");
        }
    }

    @LuaMethod(returnType=LuaType.STRING, onTick=false, description="Gets the text on the sign")
    public String getText(TileEntitySign sign) {
        return StringUtils.join((Object[])sign.field_70412_a, (char)'\n');
    }
}

