/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.vanilla;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import openmods.utils.InventoryUtils;
import openperipheral.api.Alias;
import openperipheral.api.Arg;
import openperipheral.api.IPeripheralAdapter;
import openperipheral.api.LuaCallable;
import openperipheral.api.LuaMethod;
import openperipheral.api.LuaType;
import openperipheral.api.OnTick;
import openperipheral.api.Optionals;

@OnTick
public class AdapterInventory
implements IPeripheralAdapter {
    private static final int ANY_SLOT = -1;

    @Override
    public Class<?> getTargetClass() {
        return IInventory.class;
    }

    @LuaMethod(returnType=LuaType.STRING, description="Get the name of this inventory")
    public String getInventoryName(IInventory target) {
        IInventory inventory = InventoryUtils.getInventory((IInventory)target);
        return inventory != null ? inventory.func_70303_b() : null;
    }

    @LuaMethod(returnType=LuaType.NUMBER, description="Get the size of this inventory")
    public int getInventorySize(IInventory target) {
        IInventory inventory = InventoryUtils.getInventory((IInventory)target);
        return inventory != null ? inventory.func_70302_i_() : 0;
    }

    private static void checkSlotId(IInventory inventory, int slot, String name) {
        Preconditions.checkNotNull((Object)inventory, (Object)"Invalid inventory");
        if (slot != -1) {
            Preconditions.checkElementIndex((int)slot, (int)inventory.func_70302_i_(), (String)(name + " slot id"));
        }
    }

    @Alias(value={"pullItemIntoSlot"})
    @LuaCallable(returnTypes={LuaType.NUMBER}, description="Pull an item from a slot in another inventory into a slot in this one. Returns the amount of items moved")
    public int pullItem(IInventory target, @Arg(type=LuaType.STRING, name="direction", description="The direction of the other inventory. (north, south, east, west, up or down)") ForgeDirection direction, @Arg(type=LuaType.NUMBER, name="slot", description="The slot in the OTHER inventory that you're pulling from") int fromSlot, @Optionals @Arg(type=LuaType.NUMBER, name="maxAmount", description="The maximum amount of items you want to pull") Integer maxAmount, @Arg(type=LuaType.NUMBER, name="intoSlot", description="The slot in the current inventory that you want to pull into") Integer intoSlot) {
        Preconditions.checkArgument((direction != null && direction != ForgeDirection.UNKNOWN ? 1 : 0) != 0, (Object)"Invalid direction");
        TileEntity te = (TileEntity)target;
        IInventory otherInventory = InventoryUtils.getInventory((World)te.field_70331_k, (int)te.field_70329_l, (int)te.field_70330_m, (int)te.field_70327_n, (ForgeDirection)direction);
        IInventory thisInventory = InventoryUtils.getInventory((IInventory)target);
        if (otherInventory == null || otherInventory == target) {
            return 0;
        }
        if (maxAmount == null) {
            maxAmount = 64;
        }
        if (intoSlot == null) {
            intoSlot = 0;
        }
        intoSlot = intoSlot - 1;
        AdapterInventory.checkSlotId(otherInventory, --fromSlot, "input");
        AdapterInventory.checkSlotId(thisInventory, intoSlot, "output");
        return InventoryUtils.moveItemInto((IInventory)otherInventory, (int)fromSlot, (Object)thisInventory, (int)intoSlot, (int)maxAmount, (ForgeDirection)direction.getOpposite(), (boolean)true);
    }

    @Alias(value={"pushItemIntoSlot"})
    @LuaCallable(returnTypes={LuaType.NUMBER}, description="Push an item from the current inventory into slot on the other one. Returns the amount of items moved")
    public int pushItem(IInventory target, @Arg(type=LuaType.STRING, name="direction", description="The direction of the other inventory. (north, south, east, west, up or down)") ForgeDirection direction, @Arg(type=LuaType.NUMBER, name="slot", description="The slot in the current inventory that you're pushing from") int fromSlot, @Optionals @Arg(type=LuaType.NUMBER, name="maxAmount", description="The maximum amount of items you want to push") Integer maxAmount, @Arg(type=LuaType.NUMBER, name="intoSlot", description="The slot in the other inventory that you want to push into") Integer intoSlot) {
        Preconditions.checkArgument((direction != null && direction != ForgeDirection.UNKNOWN ? 1 : 0) != 0, (Object)"Invalid direction");
        TileEntity te = (TileEntity)target;
        IInventory otherInventory = InventoryUtils.getInventory((World)te.field_70331_k, (int)te.field_70329_l, (int)te.field_70330_m, (int)te.field_70327_n, (ForgeDirection)direction);
        IInventory thisInventory = InventoryUtils.getInventory((IInventory)target);
        if (otherInventory == null || otherInventory == target) {
            return 0;
        }
        if (maxAmount == null) {
            maxAmount = 64;
        }
        if (intoSlot == null) {
            intoSlot = 0;
        }
        intoSlot = intoSlot - 1;
        AdapterInventory.checkSlotId(thisInventory, --fromSlot, "input");
        AdapterInventory.checkSlotId(otherInventory, intoSlot, "output");
        return InventoryUtils.moveItemInto((IInventory)thisInventory, (int)fromSlot, (Object)otherInventory, (int)intoSlot, (int)maxAmount, (ForgeDirection)direction, (boolean)true);
    }

    @LuaMethod(returnType=LuaType.VOID, description="Condense and tidy the stacks in an inventory")
    public void condenseItems(IInventory target) {
        IInventory inventory = InventoryUtils.getInventory((IInventory)target);
        ArrayList stacks = Lists.newArrayList();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack sta = inventory.func_70301_a(i);
            if (sta != null) {
                stacks.add(sta.func_77946_l());
            }
            inventory.func_70299_a(i, null);
        }
        for (ItemStack stack : stacks) {
            InventoryUtils.insertItemIntoInventory((IInventory)inventory, (ItemStack)stack, (ForgeDirection)ForgeDirection.UNKNOWN, (int)-1);
        }
    }

    @LuaCallable(description="Swap two slots in the inventory")
    public void swapStacks(IInventory target, @Arg(type=LuaType.NUMBER, name="from", description="The first slot") int fromSlot, @Arg(type=LuaType.NUMBER, name="to", description="The other slot") int intoSlot, @Optionals @Arg(type=LuaType.STRING, name="fromDirection") ForgeDirection fromDirection, @Arg(type=LuaType.STRING, name="fromDirection") ForgeDirection toDirection) {
        IInventory inventory = InventoryUtils.getInventory((IInventory)target);
        Preconditions.checkNotNull((Object)inventory, (Object)"Invalid target!");
        if (inventory instanceof ISidedInventory) {
            InventoryUtils.swapStacks((ISidedInventory)((ISidedInventory)inventory), (int)(fromSlot - 1), (ForgeDirection)((ForgeDirection)Objects.firstNonNull((Object)fromDirection, (Object)ForgeDirection.UNKNOWN)), (int)(intoSlot - 1), (ForgeDirection)((ForgeDirection)Objects.firstNonNull((Object)toDirection, (Object)ForgeDirection.UNKNOWN)));
        } else {
            InventoryUtils.swapStacks((IInventory)inventory, (int)(fromSlot - 1), (int)(intoSlot - 1));
        }
    }

    @LuaMethod(returnType=LuaType.TABLE, description="Get details of an item in a particular slot", args={@Arg(type=LuaType.NUMBER, name="slotNumber", description="The slot number, from 1 to the max amount of slots")})
    public ItemStack getStackInSlot(IInventory target, int slot) {
        IInventory invent = InventoryUtils.getInventory((IInventory)target);
        Preconditions.checkElementIndex((int)(--slot), (int)invent.func_70302_i_(), (String)"slot id");
        return invent.func_70301_a(slot);
    }

    @LuaMethod(returnType=LuaType.TABLE, description="Get a table with all the items of the chest")
    public ItemStack[] getAllStacks(IInventory target) {
        IInventory inventory = InventoryUtils.getInventory((IInventory)target);
        ItemStack[] allStacks = new ItemStack[inventory.func_70302_i_()];
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            allStacks[i] = inventory.func_70301_a(i);
        }
        return allStacks;
    }

    @LuaMethod(returnType=LuaType.VOID, description="Destroy a stack", args={@Arg(type=LuaType.NUMBER, name="slotNumber", description="The slot number, from 1 to the max amount of slots")})
    public void destroyStack(IInventory target, int slot) {
        IInventory invent = InventoryUtils.getInventory((IInventory)target);
        Preconditions.checkElementIndex((int)(--slot), (int)invent.func_70302_i_(), (String)"slot id");
        invent.func_70299_a(slot, null);
    }
}

