/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.vanilla;

import com.google.common.base.Preconditions;
import net.minecraft.tileentity.TileEntityDaylightDetector;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import openperipheral.api.IPeripheralAdapter;
import openperipheral.api.LuaCallable;
import openperipheral.api.LuaType;

public class AdapterDaylightSensor
implements IPeripheralAdapter {
    @Override
    public Class<?> getTargetClass() {
        return TileEntityDaylightDetector.class;
    }

    @LuaCallable(returnTypes={LuaType.BOOLEAN}, description="Get true if age has normal sky")
    public boolean hasSky(TileEntityDaylightDetector target) {
        World world = target.func_70314_l();
        return !world.field_73011_w.field_76576_e;
    }

    @LuaCallable(returnTypes={LuaType.NUMBER}, description="Get level of natural light (sky)")
    public int getSkyLight(TileEntityDaylightDetector target) {
        World world = target.func_70314_l();
        Preconditions.checkArgument((!world.field_73011_w.field_76576_e ? 1 : 0) != 0, (Object)"World has no sky");
        return world.func_72972_b(EnumSkyBlock.Sky, target.field_70329_l, target.field_70330_m, target.field_70327_n) - world.field_73008_k;
    }

    @LuaCallable(returnTypes={LuaType.NUMBER}, description="Get level of block light")
    public int getBlockLight(TileEntityDaylightDetector target) {
        World world = target.func_70314_l();
        return world.func_72972_b(EnumSkyBlock.Block, target.field_70329_l, target.field_70330_m, target.field_70327_n);
    }

    @LuaCallable(returnTypes={LuaType.NUMBER}, description="Get angle of sun (in degrees, 0 is zenith)")
    public float getCelestialAngle(TileEntityDaylightDetector target) {
        World world = target.func_70314_l();
        return world.func_72826_c(1.0f) * 360.0f;
    }
}

