/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.thaumcraft;

import java.util.List;
import java.util.Map;
import openmods.utils.ReflectionHelper;
import openperipheral.api.IPeripheralAdapter;
import openperipheral.api.LuaMethod;
import openperipheral.api.LuaType;
import openperipheral.integration.thaumcraft.AdapterAspectContainer;
import openperipheral.util.FieldAccessHelpers;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.IAspectContainer;

public class AdapterJar
implements IPeripheralAdapter {
    private static final Class<?> TILE_JAR_FILLABLE_CLASS = ReflectionHelper.getClass((String)"thaumcraft.common.tiles.TileJarFillable");

    @Override
    public Class<?> getTargetClass() {
        return TILE_JAR_FILLABLE_CLASS;
    }

    protected Aspect getFilterAspect(Object target) {
        return FieldAccessHelpers.getField(TILE_JAR_FILLABLE_CLASS, target, "aspectFilter", null);
    }

    @LuaMethod(returnType=LuaType.TABLE, description="Get the aspect filtered by this block block")
    public String getAspectFilter(Object target) {
        Aspect aspect = this.getFilterAspect(target);
        return aspect != null ? aspect.getName() : "";
    }

    @LuaMethod(returnType=LuaType.TABLE, description="Get the Aspects stored in the block")
    public List<Map<String, Object>> getAspects(IAspectContainer container) {
        Aspect filter;
        List<Map<String, Object>> result = AdapterAspectContainer.aspectsToMap(container);
        if (result.isEmpty() && (filter = this.getFilterAspect(container)) != null) {
            AdapterAspectContainer.appendAspectEntry(result, filter, 0);
        }
        return result;
    }
}

