/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.thaumcraft;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import openmods.utils.ReflectionHelper;
import openperipheral.api.IPeripheralAdapter;
import openperipheral.api.LuaMethod;
import openperipheral.api.LuaType;
import openperipheral.util.FieldAccessHelpers;

public class AdapterArcaneBore
implements IPeripheralAdapter {
    private static final Class<?> TILE_ARCANE_BORE = ReflectionHelper.getClass((String)"thaumcraft.common.tiles.TileArcaneBore");
    private static final Class<?> ITEM_ELEMENTAL_PICK = ReflectionHelper.getClass((String)"thaumcraft.common.items.equipment.ItemElementalPickaxe");

    @Override
    public Class<?> getTargetClass() {
        return TILE_ARCANE_BORE;
    }

    @LuaMethod(returnType=LuaType.BOOLEAN, description="Does the arcane bore have a pickaxe.")
    public boolean hasPickaxe(Object target) {
        return AdapterArcaneBore.getBooleanField(target, "hasPickaxe");
    }

    @LuaMethod(returnType=LuaType.BOOLEAN, description="Does the arcane bore have a focus.")
    public boolean hasFocus(Object target) {
        return AdapterArcaneBore.getBooleanField(target, "hasFocus");
    }

    public ItemStack getPick(Object bore) {
        return bore instanceof IInventory ? ((IInventory)bore).func_70301_a(1) : null;
    }

    @LuaMethod(returnType=LuaType.BOOLEAN, description="is the pick broken?")
    public boolean isPickaxeBroken(Object target) {
        ItemStack pick = this.getPick(target);
        return pick != null && pick.func_77960_j() + 1 == pick.func_77958_k();
    }

    @LuaMethod(returnType=LuaType.BOOLEAN, description="Is the Arcane bore active?")
    public boolean isWorking(Object target) {
        ItemStack pick = this.getPick(target);
        Boolean hasPower = (Boolean)ReflectionHelper.call((Object)target, (String)"gettingPower", (Object[])new Object[0]);
        return hasPower != false && this.hasFocus(target) && this.hasPickaxe(target) && pick.func_77984_f() && !this.isPickaxeBroken(target);
    }

    @LuaMethod(returnType=LuaType.NUMBER, description="gets the radius of the bore's effects")
    public int getRadius(Object target) {
        return 1 + (AdapterArcaneBore.getIntField(target, "area") + AdapterArcaneBore.getIntField(target, "maxRadius")) * 2;
    }

    @LuaMethod(returnType=LuaType.NUMBER, description="gets the speed of the bore")
    public int getSpeed(Object target) {
        return AdapterArcaneBore.getIntField(target, "speed");
    }

    @LuaMethod(returnType=LuaType.BOOLEAN, description="Does the bore mine native clusters as well as normal ores")
    public boolean hasNativeClusters(Object target) {
        ItemStack pick = this.getPick(target);
        return pick != null && ITEM_ELEMENTAL_PICK.isInstance(pick.func_77973_b());
    }

    @LuaMethod(returnType=LuaType.NUMBER, description="Gets the fortune level the Bore is mining with")
    public int getFortune(Object target) {
        ItemStack pick = this.getPick(target);
        return EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)pick);
    }

    @LuaMethod(returnType=LuaType.BOOLEAN, description="Does the Bore mine with silk touch")
    public boolean hasSilkTouch(Object target) {
        ItemStack pick = this.getPick(target);
        return EnchantmentHelper.func_77506_a((int)Enchantment.field_77348_q.field_77352_x, (ItemStack)pick) > 0;
    }

    private static int getIntField(Object target, String field) {
        return FieldAccessHelpers.getIntField(TILE_ARCANE_BORE, target, field);
    }

    private static boolean getBooleanField(Object target, String field) {
        return FieldAccessHelpers.getBooleanField(TILE_ARCANE_BORE, target, field);
    }
}

