/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.sgcraft;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.lang.reflect.Field;
import net.minecraft.tileentity.TileEntity;
import openmods.utils.ReflectionHelper;
import openperipheral.api.Arg;
import openperipheral.api.IPeripheralAdapter;
import openperipheral.api.LuaCallable;
import openperipheral.api.LuaMethod;
import openperipheral.api.LuaType;
import openperipheral.api.OnTick;

public class AdapterStargate
implements IPeripheralAdapter {
    private static final Class<?> STARGATE_TILE_CLASS = ReflectionHelper.getClass((String)"gcewing.sg.SGBaseTE");
    private static final Class<?> SG_ADDRESSING_CLASS = ReflectionHelper.getClass((String)"gcewing.sg.SGAddressing");

    @Override
    public Class<?> getTargetClass() {
        return STARGATE_TILE_CLASS;
    }

    @OnTick
    @LuaCallable(description="Connects the stargate to the supplied address")
    public void connect(TileEntity tile, @Arg(name="targetAddress", type=LuaType.STRING, description="the address of the gate to connect to") String targetAddress) {
        AdapterStargate.checkGateComplete(tile);
        targetAddress = targetAddress.toUpperCase();
        AdapterStargate.validateAddress(tile, targetAddress);
        String homeAddress = (String)ReflectionHelper.call((Object)tile, (String)"findHomeAddress", (Object[])new Object[0]);
        TileEntity targetStargate = (TileEntity)ReflectionHelper.callStatic(SG_ADDRESSING_CLASS, (String)"findAddressedStargate", (Object[])new Object[]{targetAddress});
        boolean targetBusy = (Boolean)ReflectionHelper.call((Object)targetStargate, (String)"isConnected", (Object[])new Object[0]);
        Preconditions.checkState((!targetBusy ? 1 : 0) != 0, (String)"Stargate at address %s is busy", (Object[])new Object[]{targetAddress});
        int requiredFuel = (Integer)ReflectionHelper.getProperty(STARGATE_TILE_CLASS, (Object)tile, (String[])new String[]{"fuelToOpen"});
        boolean fuelReloaded = (Boolean)ReflectionHelper.call((Object)tile, (String)"reloadFuel", (Object[])new Object[]{ReflectionHelper.primitive((int)requiredFuel)});
        Preconditions.checkState((boolean)fuelReloaded, (Object)"Stargate has insufficient fuel");
        ReflectionHelper.call((Object)tile, (String)"startDiallingStargate", (Object[])new Object[]{targetAddress, targetStargate, ReflectionHelper.primitive((boolean)true)});
        ReflectionHelper.call((Object)targetStargate, (String)"startDiallingStargate", (Object[])new Object[]{homeAddress, tile, ReflectionHelper.primitive((boolean)false)});
    }

    @LuaMethod(returnType=LuaType.STRING, description="Gets state of the stargate")
    public String getState(TileEntity tile) {
        AdapterStargate.checkGateComplete(tile);
        Field field = ReflectionHelper.getField(STARGATE_TILE_CLASS, (String[])new String[]{"state"});
        try {
            return field.get(tile).toString();
        }
        catch (Throwable t) {
            throw Throwables.propagate((Throwable)t);
        }
    }

    @LuaMethod(returnType=LuaType.NUMBER, description="Gets the number of locked chevrons")
    public int getLockedChevronCount(TileEntity tile) {
        AdapterStargate.checkGateComplete(tile);
        Field field = ReflectionHelper.getField(STARGATE_TILE_CLASS, (String[])new String[]{"numEngagedChevrons"});
        try {
            return field.getInt(tile);
        }
        catch (Throwable t) {
            throw Throwables.propagate((Throwable)t);
        }
    }

    @LuaMethod(returnType=LuaType.NUMBER, description="Gets the amount of buffered fuel")
    public int getFuelLevel(TileEntity tile) {
        AdapterStargate.checkGateComplete(tile);
        Field field = ReflectionHelper.getField(STARGATE_TILE_CLASS, (String[])new String[]{"fuelBuffer"});
        try {
            return field.getInt(tile);
        }
        catch (Throwable t) {
            throw Throwables.propagate((Throwable)t);
        }
    }

    @LuaMethod(returnType=LuaType.NUMBER, description="Gets maximum amount of buffered fuel")
    public int getMaxFuelLevel(TileEntity tile) {
        AdapterStargate.checkGateComplete(tile);
        Field field = ReflectionHelper.getField(STARGATE_TILE_CLASS, (String[])new String[]{"maxFuelBuffer"});
        try {
            return field.getInt(tile);
        }
        catch (Throwable t) {
            throw Throwables.propagate((Throwable)t);
        }
    }

    @LuaMethod(returnType=LuaType.NUMBER, description="Is the stargate connected to a controller")
    public boolean isDHDConnected(TileEntity tile) {
        AdapterStargate.checkGateComplete(tile);
        Field field = ReflectionHelper.getField(STARGATE_TILE_CLASS, (String[])new String[]{"isLinkedToController"});
        try {
            return field.getBoolean(tile);
        }
        catch (Throwable t) {
            throw Throwables.propagate((Throwable)t);
        }
    }

    @LuaMethod(returnType=LuaType.VOID, description="Disconnects the stargate")
    public void disconnect(TileEntity tile) {
        AdapterStargate.checkGateComplete(tile);
        Object connectedLocation = ReflectionHelper.getProperty(STARGATE_TILE_CLASS, (Object)tile, (String[])new String[]{"connectedLocation"});
        TileEntity connectedGate = (TileEntity)ReflectionHelper.call((Object)tile, (String)"at", (Object[])new Object[]{connectedLocation});
        if (connectedGate != null) {
            ReflectionHelper.call((Object)connectedGate, (String)"clearConnection", (Object[])new Object[0]);
        }
        ReflectionHelper.call((Object)tile, (String)"clearConnection", (Object[])new Object[0]);
    }

    @LuaMethod(returnType=LuaType.BOOLEAN, description="Whether or not the supplied address is a valid address", args={@Arg(type=LuaType.STRING, description="the address of the gate to validate")})
    public boolean isValidAddress(TileEntity tile, String address) {
        try {
            AdapterStargate.validateAddress(tile, address.toUpperCase());
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    @LuaMethod(returnType=LuaType.BOOLEAN, description="Whether or not the stargate currently has a connection")
    public boolean isConnected(TileEntity tile) {
        AdapterStargate.checkGateComplete(tile);
        return (Boolean)ReflectionHelper.call((Object)tile, (String)"isConnected", (Object[])new Object[0]);
    }

    @LuaMethod(returnType=LuaType.BOOLEAN, description="Whether or not the stargate created the connection")
    public boolean isInitiator(TileEntity tile) {
        AdapterStargate.checkGateComplete(tile);
        return (Boolean)ReflectionHelper.getProperty(STARGATE_TILE_CLASS, (Object)tile, (String[])new String[]{"isInitiator"});
    }

    @LuaMethod(returnType=LuaType.BOOLEAN, description="Whether or not the connection is travelable from this side")
    public boolean canTravelFromThisEnd(TileEntity tile) {
        AdapterStargate.checkGateComplete(tile);
        return (Boolean)ReflectionHelper.call((Object)tile, (String)"canTravelFromThisEnd", (Object[])new Object[0]);
    }

    @LuaMethod(returnType=LuaType.STRING, description="The address of the stargate the connection is linked")
    public String getDialledAddress(TileEntity tile) {
        AdapterStargate.checkGateComplete(tile);
        return (String)ReflectionHelper.getProperty(STARGATE_TILE_CLASS, (Object)tile, (String[])new String[]{"dialledAddress"});
    }

    @LuaMethod(returnType=LuaType.STRING, description="The address of the this stargate")
    public String getHomeAddress(TileEntity tile) {
        AdapterStargate.checkGateComplete(tile);
        return (String)ReflectionHelper.call((Object)tile, (String)"findHomeAddress", (Object[])new Object[0]);
    }

    @LuaMethod(returnType=LuaType.BOOLEAN, description="Whether or not the Stargate is completed")
    public boolean isCompleteGate(TileEntity tile) {
        try {
            AdapterStargate.checkGateComplete(tile);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static void checkGateComplete(TileEntity tile) {
        boolean ringComplete = (Boolean)ReflectionHelper.getProperty(STARGATE_TILE_CLASS, (Object)tile, (String[])new String[]{"isMerged"});
        Preconditions.checkState((boolean)ringComplete, (Object)"Stargate damaged or incomplete");
    }

    private static void validateAddress(TileEntity tile, String address) {
        Preconditions.checkArgument((address.length() == 7 ? 1 : 0) != 0, (Object)"Stargate addresses must be 7 letters");
        TileEntity targetStargate = (TileEntity)ReflectionHelper.callStatic(SG_ADDRESSING_CLASS, (String)"findAddressedStargate", (Object[])new Object[]{address});
        Preconditions.checkNotNull((Object)targetStargate, (String)"No Stargate at address %s", (Object[])new Object[]{address});
        Preconditions.checkArgument((targetStargate != tile ? 1 : 0) != 0, (Object)"Stargate cannot connect to itself");
    }
}

