/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.mystcraft;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.FakePlayer;
import net.minecraftforge.common.ForgeDirection;
import openmods.utils.BlockUtils;
import openmods.utils.InventoryUtils;
import openmods.utils.ReflectionHelper;
import openperipheral.api.Arg;
import openperipheral.api.IPeripheralAdapter;
import openperipheral.api.LuaCallable;
import openperipheral.api.LuaMethod;
import openperipheral.api.LuaType;
import openperipheral.api.Optionals;
import openperipheral.integration.mystcraft.NotebookIInventoryWrapper;

public class AdapterWritingDesk
implements IPeripheralAdapter {
    private static final Class<?> DESK_CLASS = ReflectionHelper.getClass((String)"com.xcompwiz.mystcraft.tileentity.TileEntityDesk");

    @Override
    public Class<?> getTargetClass() {
        return DESK_CLASS;
    }

    @LuaMethod(description="Get the maximum number of notebooks this desk can store", returnType=LuaType.NUMBER)
    public int getMaxNotebookCount(Object tileEntityDesk) {
        return (Integer)ReflectionHelper.call((Object)tileEntityDesk, (String)"getMaxNotebookCount", (Object[])new Object[0]);
    }

    @LuaMethod(description="Get the name of a notebook", returnType=LuaType.STRING, args={@Arg(name="slot", type=LuaType.NUMBER, description="The writing desk slot you are interested in")})
    public String getNotebookName(Object desk, int deskSlot) {
        return AdapterWritingDesk.createInventoryWrapper(desk, deskSlot).func_70303_b();
    }

    @LuaMethod(description="Get the number of pages in a notebook", returnType=LuaType.NUMBER, args={@Arg(name="slot", type=LuaType.NUMBER, description="The writing desk slot you are interested in")})
    public Integer getNotebookSize(Object desk, int deskSlot) {
        return (Integer)AdapterWritingDesk.createInventoryWrapper(desk, deskSlot).callOnNotebook("getItemCount", new Object[0]);
    }

    @LuaMethod(description="Get the contents of a slot in a notebook", returnType=LuaType.NUMBER, args={@Arg(name="deskSlot", type=LuaType.NUMBER, description="The writing desk slot you are interested in"), @Arg(name="notebookSlot", type=LuaType.NUMBER, description="The notebook slot you are interested in")})
    public ItemStack getNotebookStackInSlot(Object desk, int deskSlot, int notebookSlot) {
        return AdapterWritingDesk.createInventoryWrapper(desk, deskSlot).func_70301_a(notebookSlot - 1);
    }

    @LuaMethod(description="Get the last slot index in a notebook", returnType=LuaType.NUMBER, args={@Arg(name="slot", type=LuaType.NUMBER, description="The writing desk slot you are interested in")})
    public Integer getLastNotebookSlot(Object desk, int deskSlot) {
        return AdapterWritingDesk.createInventoryWrapper(desk, deskSlot).func_70302_i_() - 1;
    }

    @LuaMethod(description="Swap notebook slots", returnType=LuaType.VOID, args={@Arg(name="deskSlot", type=LuaType.NUMBER, description="The writing desk slot you are interested in"), @Arg(type=LuaType.NUMBER, name="from", description="The first slot"), @Arg(type=LuaType.NUMBER, name="to", description="The other slot")})
    public void swapNotebookPages(Object desk, int deskSlot, int from, int to) {
        InventoryUtils.swapStacks((IInventory)AdapterWritingDesk.createInventoryWrapper(desk, deskSlot), (int)(from - 1), (int)(to - 1));
    }

    @LuaCallable(returnTypes={LuaType.NUMBER}, description="Push a page from the notebook into a specific slot in external inventory. Returns the amount of items moved")
    public int pushNotebookPage(Object desk, @Arg(type=LuaType.NUMBER, name="deskSlot", description="The notebook slot you are interested in") int deskSlot, @Arg(type=LuaType.STRING, name="direction", description="The direction of the other inventory. (north, south, east, west, up or down)") ForgeDirection direction, @Arg(type=LuaType.NUMBER, name="fromSlot", description="The page slot in inventory that you're pushing from") int fromSlot, @Optionals @Arg(type=LuaType.NUMBER, name="intoSlot", description="The slot in the other inventory that you want to push into") Integer intoSlot) {
        NotebookIInventoryWrapper source = AdapterWritingDesk.createInventoryWrapper(desk, deskSlot);
        IInventory target = AdapterWritingDesk.getTargetTile(desk, direction);
        return InventoryUtils.moveItemInto((IInventory)source, (int)(fromSlot - 1), (Object)target, (int)((Integer)Objects.firstNonNull((Object)intoSlot, (Object)0) - 1), (int)64, (ForgeDirection)direction.getOpposite(), (boolean)true);
    }

    @LuaMethod(returnType=LuaType.NUMBER, description="Pull an item from the target inventory into any slot in the current one. Returns the amount of items moved", args={@Arg(type=LuaType.NUMBER, name="deskSlot", description="The writing desk slot you are interested in"), @Arg(type=LuaType.STRING, name="direction", description="The direction of the other inventory. (north, south, east, west, up or down)"), @Arg(type=LuaType.NUMBER, name="fromSlot", description="The slot in the other inventory that you're pulling from")})
    public int pullNotebookPage(Object desk, int deskSlot, ForgeDirection direction, int notebookSlot) {
        IInventory source = AdapterWritingDesk.getTargetTile(desk, direction);
        NotebookIInventoryWrapper target = AdapterWritingDesk.createInventoryWrapper(desk, deskSlot);
        return InventoryUtils.moveItemInto((IInventory)source, (int)(notebookSlot - 1), (Object)target, (int)-1, (int)1, (ForgeDirection)direction.getOpposite(), (boolean)true, (boolean)false);
    }

    @LuaMethod(description="Create a symbol page from the target symbol", returnType=LuaType.VOID, args={@Arg(name="deskSlot", type=LuaType.NUMBER, description="The writing desk slot you are interested in"), @Arg(type=LuaType.NUMBER, name="notebookSlot", description="The source symbol to copy")})
    public void writeSymbol(TileEntity desk, int deskSlot, int notebookSlot) {
        String symbol = AdapterWritingDesk.getSymbolFromPage(this.getNotebookStackInSlot(desk, deskSlot, notebookSlot));
        if (symbol != null) {
            FakePlayer fakePlayer = new FakePlayer(desk.func_70314_l(), "OpenPeripheral");
            ReflectionHelper.call(DESK_CLASS, (Object)desk, (String)"writeSymbol", (Object[])new Object[]{fakePlayer, symbol});
        }
    }

    private static String getSymbolFromPage(ItemStack info) {
        NBTTagCompound tag;
        Item item;
        if (info != null && info.func_77942_o() && (item = info.func_77973_b()) != null && "item.myst.page".equals(item.func_77658_a()) && (tag = info.func_77978_p()) != null) {
            return tag.func_74779_i("symbol");
        }
        return null;
    }

    private static IInventory getTargetTile(Object target, ForgeDirection direction) {
        Preconditions.checkArgument((direction != ForgeDirection.UNKNOWN ? 1 : 0) != 0, (Object)"Invalid direction");
        Preconditions.checkArgument((boolean)(target instanceof TileEntity));
        TileEntity targetTile = BlockUtils.getTileInDirection((TileEntity)((TileEntity)target), (ForgeDirection)direction);
        Preconditions.checkArgument((boolean)(targetTile instanceof IInventory), (Object)"Target direction is not a valid inventory");
        return (IInventory)targetTile;
    }

    private static NotebookIInventoryWrapper createInventoryWrapper(Object tile, int number) {
        ItemStack notebook = (ItemStack)ReflectionHelper.call(DESK_CLASS, (Object)tile, (String)"getNotebook", (Object[])new Object[]{ReflectionHelper.primitive((byte)((byte)(number - 1)))});
        return new NotebookIInventoryWrapper(notebook);
    }
}

