/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.multiparts;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import openmods.utils.ReflectionHelper;
import openperipheral.api.IPeripheralAdapter;
import openperipheral.api.LuaCallable;
import openperipheral.api.LuaType;

public class AdapterMultipart
implements IPeripheralAdapter {
    private static final Class<?> TARGET_CLASS = ReflectionHelper.getClass((String)"codechicken.multipart.TileMultipart");
    private static final Class<?> PART_CLASS = ReflectionHelper.getClass((String)"codechicken.multipart.TMultiPart");

    @Override
    public Class<?> getTargetClass() {
        return TARGET_CLASS;
    }

    @LuaCallable(returnTypes={LuaType.TABLE}, description="List types of parts in multipart block")
    public List<String> getParts(Object target) {
        try {
            Method partListMethod = TARGET_CLASS.getMethod("jPartList", new Class[0]);
            Method getTypeMethod = PART_CLASS.getMethod("getType", new Class[0]);
            List partList = (List)partListMethod.invoke(target, new Object[0]);
            ArrayList result = Lists.newArrayList();
            for (Object part : partList) {
                String type = (String)getTypeMethod.invoke(part, new Object[0]);
                result.add(type);
            }
            return result;
        }
        catch (Throwable t) {
            throw Throwables.propagate((Throwable)t);
        }
    }
}

