/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.minefactoryreloaded;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;
import openperipheral.adapter.AdapterManager;
import openperipheral.api.IIntegrationModule;
import openperipheral.integration.minefactoryreloaded.AdapterAutoAnvil;
import openperipheral.integration.minefactoryreloaded.AdapterAutoDisenchanter;
import openperipheral.integration.minefactoryreloaded.AdapterAutoEnchanter;
import openperipheral.integration.minefactoryreloaded.AdapterAutoJukebox;
import openperipheral.integration.minefactoryreloaded.AdapterAutoSpawner;
import openperipheral.integration.minefactoryreloaded.AdapterChronotyper;
import openperipheral.integration.minefactoryreloaded.AdapterChunkLoader;
import openperipheral.integration.minefactoryreloaded.AdapterEjector;
import openperipheral.integration.minefactoryreloaded.AdapterHarvester;

public class ModuleMinefactoryReloaded
implements IIntegrationModule {
    private static final Set<String> safariNets = ImmutableSet.of((Object)"item.mfr.safarinet.reusable", (Object)"item.mfr.safarinet.singleuse", (Object)"item.mfr.safarinet.jailer");

    @Override
    public String getModId() {
        return "MineFactoryReloaded";
    }

    @Override
    public void init() {
        AdapterManager.addPeripheralAdapter(new AdapterAutoAnvil());
        AdapterManager.addPeripheralAdapter(new AdapterAutoDisenchanter());
        AdapterManager.addPeripheralAdapter(new AdapterAutoEnchanter());
        AdapterManager.addPeripheralAdapter(new AdapterAutoJukebox());
        AdapterManager.addPeripheralAdapter(new AdapterAutoSpawner());
        AdapterManager.addPeripheralAdapter(new AdapterChronotyper());
        AdapterManager.addPeripheralAdapter(new AdapterChunkLoader());
        AdapterManager.addPeripheralAdapter(new AdapterEjector());
        AdapterManager.addPeripheralAdapter(new AdapterHarvester());
    }

    @Override
    public void appendItemInfo(Map<String, Object> map, ItemStack stack) {
        NBTTagCompound tag;
        Preconditions.checkNotNull((Object)stack);
        if (ModuleMinefactoryReloaded.isSafariNet(stack) && (tag = stack.func_77978_p()) != null && tag.func_74764_b("id")) {
            map.put("captured", tag.func_74779_i("id"));
        }
    }

    private static boolean isSafariNet(ItemStack stack) {
        Item item = stack.func_77973_b();
        return item != null && safariNets.contains(item.func_77658_a());
    }

    @Override
    public void appendEntityInfo(Map<String, Object> map, Entity entity, Vec3 relativePos) {
    }
}

