/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.minefactoryreloaded;

import java.util.Map;
import openmods.utils.ReflectionHelper;
import openperipheral.api.Arg;
import openperipheral.api.IPeripheralAdapter;
import openperipheral.api.LuaMethod;
import openperipheral.api.LuaType;

public class AdapterHarvester
implements IPeripheralAdapter {
    private static final Class<?> HARVESTER_CLASS = ReflectionHelper.getClass((String)"powercrystals.minefactoryreloaded.tile.machine.TileEntityHarvester");

    @Override
    public Class<?> getTargetClass() {
        return HARVESTER_CLASS;
    }

    @LuaMethod(description="Get value of shear leaves", returnType=LuaType.BOOLEAN)
    public Boolean getShearLeaves(Object tileEntityHarvester) {
        return AdapterHarvester.getSettings(tileEntityHarvester).get("silkTouch");
    }

    @LuaMethod(description="Get value of harvest small mushrooms", returnType=LuaType.BOOLEAN)
    public Boolean getHarvestShrooms(Object tileEntityHarvester) {
        return AdapterHarvester.getSettings(tileEntityHarvester).get("harvestSmallMushrooms");
    }

    @LuaMethod(description="Set value of shear leaves", returnType=LuaType.VOID, args={@Arg(name="shearLeaves", type=LuaType.BOOLEAN, description="boolean: Shear leaves?")})
    public void setShearLeaves(Object tileEntityHarvester, boolean shearLeaves) {
        AdapterHarvester.getSettings(tileEntityHarvester).put("silkTouch", shearLeaves);
    }

    @LuaMethod(description="Set value of harvest small mushrooms", returnType=LuaType.VOID, args={@Arg(name="harvestShrooms", type=LuaType.BOOLEAN, description="boolean: Harvest shrooms?")})
    public void setHarvestShrooms(Object tileEntityHarvester, boolean harvestShrooms) {
        AdapterHarvester.getSettings(tileEntityHarvester).put("harvestSmallMushrooms", harvestShrooms);
    }

    private static Map<String, Boolean> getSettings(Object tileEntityHarvester) {
        return (Map)ReflectionHelper.call((Object)tileEntityHarvester, (String)"getSettings", (Object[])new Object[0]);
    }
}

