/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.ic2;

import com.google.common.base.Preconditions;
import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorChamber;
import openperipheral.api.IPeripheralAdapter;
import openperipheral.api.LuaMethod;
import openperipheral.api.LuaType;

public class AdapterReactorChamber
implements IPeripheralAdapter {
    @Override
    public Class<?> getTargetClass() {
        return IReactorChamber.class;
    }

    private static IReactor getReactor(IReactorChamber chamber) {
        IReactor reactor = chamber.getReactor();
        Preconditions.checkNotNull((Object)reactor, (Object)"No reactor");
        return reactor;
    }

    @LuaMethod(onTick=false, description="Check if reactor is in valid state", returnType=LuaType.BOOLEAN)
    public boolean isValid(IReactorChamber chamber) {
        return chamber.getReactor() != null;
    }

    @LuaMethod(onTick=false, description="Get the heat of the reactor", returnType=LuaType.NUMBER)
    public int getHeat(IReactorChamber chamber) {
        return AdapterReactorChamber.getReactor(chamber).getHeat();
    }

    @LuaMethod(onTick=false, description="Get the maximum heat of the reactor before it explodes", returnType=LuaType.NUMBER)
    public int getMaxHeat(IReactorChamber chamber) {
        return AdapterReactorChamber.getReactor(chamber).getMaxHeat();
    }

    @LuaMethod(onTick=false, description="Get the EU output of this reactor", returnType=LuaType.NUMBER)
    public float getEUOutput(IReactorChamber chamber) {
        return AdapterReactorChamber.getReactor(chamber).getReactorEnergyOutput();
    }

    @LuaMethod(onTick=false, description="Returns true if the reactor is active", returnType=LuaType.BOOLEAN)
    public boolean isActive(IReactorChamber chamber) {
        return AdapterReactorChamber.getReactor(chamber).produceEnergy();
    }
}

