/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.forestry;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.IAlleleFruit;
import forestry.api.arboriculture.IAlleleGrowth;
import forestry.api.arboriculture.IAlleleLeafEffect;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleArea;
import forestry.api.genetics.IAlleleBoolean;
import forestry.api.genetics.IAlleleFloat;
import forestry.api.genetics.IAlleleFlowers;
import forestry.api.genetics.IAlleleInteger;
import forestry.api.genetics.IAllelePlantType;
import forestry.api.genetics.IAlleleTolerance;
import forestry.api.genetics.IChromosome;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IIndividualLiving;
import forestry.api.lepidopterology.EnumButterflyChromosome;
import forestry.api.lepidopterology.IAlleleButterflyEffect;
import forestry.api.lepidopterology.IAlleleButterflySpecies;
import forestry.api.lepidopterology.IButterfly;
import forestry.api.lepidopterology.IButterflyGenome;
import java.util.HashMap;
import java.util.Map;
import openperipheral.TypeConversionRegistry;
import openperipheral.api.ITypeConverter;

public class ConverterIIndividual
implements ITypeConverter {
    private static final GenomeAccess ACTIVE = new GenomeAccess(){

        @Override
        protected IAllele getAllele(IChromosome chromosome) {
            return chromosome.getActiveAllele();
        }
    };
    private static final GenomeAccess INACTIVE = new GenomeAccess(){

        @Override
        protected IAllele getAllele(IChromosome chromosome) {
            return chromosome.getInactiveAllele();
        }
    };
    private static final Map<Class<? extends IAllele>, IAlleleConverter<?>> conventers = ImmutableMap.builder().put(IAlleleFloat.class, (Object)new IAlleleConverter<IAlleleFloat>(){

        @Override
        public Object convert(IAlleleFloat allele) {
            return Float.valueOf(allele.getValue());
        }
    }).put(IAlleleInteger.class, (Object)new IAlleleConverter<IAlleleInteger>(){

        @Override
        public Object convert(IAlleleInteger allele) {
            return allele.getValue();
        }
    }).put(IAlleleBoolean.class, (Object)new IAlleleConverter<IAlleleBoolean>(){

        @Override
        public Object convert(IAlleleBoolean allele) {
            return allele.getValue();
        }
    }).put(IAlleleArea.class, (Object)new IAlleleConverter<IAlleleArea>(){

        @Override
        public Object convert(IAlleleArea allele) {
            return allele.getValue();
        }
    }).put(IAllelePlantType.class, (Object)new IAlleleConverter<IAllelePlantType>(){

        @Override
        public Object convert(IAllelePlantType allele) {
            return allele.getPlantTypes();
        }
    }).put(IAlleleGrowth.class, (Object)new IAlleleConverter<IAlleleGrowth>(){

        @Override
        public Object convert(IAlleleGrowth allele) {
            return allele.getProvider().getInfo();
        }
    }).build();

    @Override
    public Object fromLua(Object obj, Class<?> expected) {
        return null;
    }

    @Override
    public Object toLua(Object obj) {
        if (obj instanceof IIndividual) {
            HashMap map = Maps.newHashMap();
            IIndividual individual = (IIndividual)obj;
            map.put("displayName", individual.getDisplayName());
            map.put("ident", individual.getIdent());
            boolean isAnalyzed = individual.isAnalyzed();
            map.put("isAnalyzed", isAnalyzed);
            map.put("isSecret", individual.isSecret());
            GenomeReader genomeReader = null;
            if (individual instanceof IIndividualLiving) {
                IIndividualLiving living = (IIndividualLiving)individual;
                map.put("health", living.getHealth());
                map.put("maxHealth", living.getMaxHealth());
            }
            if (individual instanceof IBee) {
                IBee bee = (IBee)individual;
                map.put("type", "bee");
                map.put("canSpawn", bee.canSpawn());
                map.put("generation", bee.getGeneration());
                map.put("hasEffect", bee.hasEffect());
                map.put("isAlive", bee.isAlive());
                map.put("isIrregularMating", bee.isIrregularMating());
                map.put("isNatural", bee.isNatural());
                if (isAnalyzed) {
                    genomeReader = new BeeGenomeReader(bee.getGenome());
                }
            } else if (individual instanceof IButterfly) {
                IButterfly butterfly = (IButterfly)individual;
                map.put("type", "butterfly");
                map.put("size", Float.valueOf(butterfly.getSize()));
                if (isAnalyzed) {
                    genomeReader = new ButterflyGenomeReader(butterfly.getGenome());
                }
            } else if (individual instanceof ITree) {
                ITree tree = (ITree)individual;
                map.put("type", "tree");
                map.put("plantType", tree.getPlantTypes().toString());
                if (isAnalyzed) {
                    genomeReader = new TreeGenomeReader(tree.getGenome());
                }
            }
            if (genomeReader != null) {
                map.put("active", genomeReader.getActiveInfo());
                map.put("inactive", genomeReader.getInactiveInfo());
            }
            return TypeConversionRegistry.toLua(map);
        }
        return null;
    }

    private static class TreeGenomeReader
    extends GenomeReader<ITreeGenome, EnumTreeChromosome> {
        public TreeGenomeReader(ITreeGenome genome) {
            super(genome);
        }

        @Override
        protected void addAlleleInfo(GenomeAccess access, Map<String, Object> result) {
            result.put("species", this.convertAllele(access, IAlleleTreeSpecies.class, EnumTreeChromosome.SPECIES));
            result.put("growth", this.convertAllele(access, IAlleleGrowth.class, EnumTreeChromosome.GROWTH));
            result.put("height", this.convertAllele(access, IAlleleFloat.class, EnumTreeChromosome.HEIGHT));
            result.put("fertility", this.convertAllele(access, IAlleleFloat.class, EnumTreeChromosome.FERTILITY));
            result.put("fruits", this.convertAllele(access, IAlleleFruit.class, EnumTreeChromosome.FRUITS));
            result.put("yield", this.convertAllele(access, IAlleleFloat.class, EnumTreeChromosome.YIELD));
            result.put("plant", this.convertAllele(access, IAllelePlantType.class, EnumTreeChromosome.PLANT));
            result.put("sappiness", this.convertAllele(access, IAlleleFloat.class, EnumTreeChromosome.SAPPINESS));
            result.put("territory", this.convertAllele(access, IAlleleArea.class, EnumTreeChromosome.TERRITORY));
            result.put("effect", this.convertAllele(access, IAlleleLeafEffect.class, EnumTreeChromosome.EFFECT));
            result.put("maturation", this.convertAllele(access, IAlleleInteger.class, EnumTreeChromosome.MATURATION));
            result.put("girth", this.convertAllele(access, IAlleleInteger.class, EnumTreeChromosome.GIRTH));
        }
    }

    private static class ButterflyGenomeReader
    extends GenomeReader<IButterflyGenome, EnumButterflyChromosome> {
        public ButterflyGenomeReader(IButterflyGenome genome) {
            super(genome);
        }

        @Override
        protected void addAlleleInfo(GenomeAccess access, Map<String, Object> result) {
            result.put("species", this.convertAllele(access, IAlleleButterflySpecies.class, EnumButterflyChromosome.SPECIES));
            result.put("size", this.convertAllele(access, IAlleleFloat.class, EnumButterflyChromosome.SIZE));
            result.put("speed", this.convertAllele(access, IAlleleFloat.class, EnumButterflyChromosome.SPEED));
            result.put("lifespan", this.convertAllele(access, IAlleleInteger.class, EnumButterflyChromosome.LIFESPAN));
            result.put("metabolism", this.convertAllele(access, IAlleleInteger.class, EnumButterflyChromosome.METABOLISM));
            result.put("fertility", this.convertAllele(access, IAlleleInteger.class, EnumButterflyChromosome.FERTILITY));
            result.put("temperatureTolerance", this.convertAllele(access, IAlleleTolerance.class, EnumButterflyChromosome.TEMPERATURE_TOLERANCE));
            result.put("humidityTolerance", this.convertAllele(access, IAlleleTolerance.class, EnumButterflyChromosome.HUMIDITY_TOLERANCE));
            result.put("nocturnal", this.convertAllele(access, IAlleleBoolean.class, EnumButterflyChromosome.NOCTURNAL));
            result.put("tolerantFlyer", this.convertAllele(access, IAlleleBoolean.class, EnumButterflyChromosome.TOLERANT_FLYER));
            result.put("fireResist", this.convertAllele(access, IAlleleBoolean.class, EnumButterflyChromosome.FIRE_RESIST));
            result.put("flowerProvider", this.convertAllele(access, IAlleleFlowers.class, EnumButterflyChromosome.FLOWER_PROVIDER));
            result.put("effect", this.convertAllele(access, IAlleleButterflyEffect.class, EnumButterflyChromosome.EFFECT));
            result.put("territory", this.convertAllele(access, IAlleleArea.class, EnumButterflyChromosome.TERRITORY));
        }
    }

    private static class BeeGenomeReader
    extends GenomeReader<IBeeGenome, EnumBeeChromosome> {
        public BeeGenomeReader(IBeeGenome genome) {
            super(genome);
        }

        @Override
        protected void addAlleleInfo(GenomeAccess access, Map<String, Object> result) {
            result.put("species", this.convertAllele(access, IAlleleBeeSpecies.class, EnumBeeChromosome.SPECIES));
            result.put("speed", this.convertAllele(access, IAlleleFloat.class, EnumBeeChromosome.SPEED));
            result.put("lifespan", this.convertAllele(access, IAlleleInteger.class, EnumBeeChromosome.LIFESPAN));
            result.put("fertility", this.convertAllele(access, IAlleleInteger.class, EnumBeeChromosome.FERTILITY));
            result.put("temperatureTolerance", this.convertAllele(access, IAlleleTolerance.class, EnumBeeChromosome.TEMPERATURE_TOLERANCE));
            result.put("nocturnal", this.convertAllele(access, IAlleleBoolean.class, EnumBeeChromosome.NOCTURNAL));
            result.put("humidityTolerance", this.convertAllele(access, IAlleleTolerance.class, EnumBeeChromosome.HUMIDITY_TOLERANCE));
            result.put("tolerantFlyer", this.convertAllele(access, IAlleleBoolean.class, EnumBeeChromosome.TOLERANT_FLYER));
            result.put("caveDwelling", this.convertAllele(access, IAlleleBoolean.class, EnumBeeChromosome.CAVE_DWELLING));
            result.put("flowerProvider", this.convertAllele(access, IAlleleFlowers.class, EnumBeeChromosome.FLOWER_PROVIDER));
            result.put("flowering", this.convertAllele(access, IAlleleInteger.class, EnumBeeChromosome.FLOWERING));
            result.put("effect", this.convertAllele(access, IAlleleBeeEffect.class, EnumBeeChromosome.EFFECT));
            result.put("territory", this.convertAllele(access, IAlleleArea.class, EnumBeeChromosome.TERRITORY));
        }
    }

    private static abstract class GenomeReader<G extends IGenome, E extends Enum<E>> {
        private final G genome;

        public GenomeReader(G genome) {
            this.genome = genome;
        }

        protected <A extends IAllele> A getAllele(GenomeAccess access, Class<A> cls, E chromosome) {
            Preconditions.checkArgument((((IChromosomeType)chromosome).getAlleleClass() == cls ? 1 : 0) != 0);
            IAllele allele = access.getAllele((IGenome)this.genome, ((Enum)chromosome).ordinal());
            return (A)allele;
        }

        protected <A extends IAllele> Object convertAllele(GenomeAccess access, Class<A> cls, E chromosome) {
            A allele = this.getAllele(access, cls, chromosome);
            if (allele == null) {
                return "missing";
            }
            IAlleleConverter conventer = (IAlleleConverter)conventers.get(cls);
            return conventer != null ? conventer.convert(allele) : allele.getName();
        }

        protected abstract void addAlleleInfo(GenomeAccess var1, Map<String, Object> var2);

        public Map<String, Object> getActiveInfo() {
            HashMap result = Maps.newHashMap();
            this.addAlleleInfo(ACTIVE, result);
            return result;
        }

        public Map<String, Object> getInactiveInfo() {
            HashMap result = Maps.newHashMap();
            this.addAlleleInfo(INACTIVE, result);
            return result;
        }
    }

    private static interface IAlleleConverter<A extends IAllele> {
        public Object convert(A var1);
    }

    private static abstract class GenomeAccess {
        private GenomeAccess() {
        }

        public IAllele getAllele(IGenome genome, int chromosome) {
            IChromosome[] genotype = genome.getChromosomes();
            IChromosome ch = genotype[chromosome];
            if (ch == null) {
                return null;
            }
            return this.getAllele(ch);
        }

        protected abstract IAllele getAllele(IChromosome var1);
    }
}

