/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.enderstorage;

import com.google.common.base.Preconditions;
import net.minecraft.tileentity.TileEntity;
import openmods.utils.ColorUtils;
import openmods.utils.ReflectionHelper;
import openperipheral.api.Alias;
import openperipheral.api.Arg;
import openperipheral.api.IMultiReturn;
import openperipheral.api.IPeripheralAdapter;
import openperipheral.api.LuaCallable;
import openperipheral.api.LuaMethod;
import openperipheral.api.LuaType;
import openperipheral.api.OpenPeripheralAPI;

public class AdapterFrequencyOwner
implements IPeripheralAdapter {
    private static final Class<?> CLAZZ = ReflectionHelper.getClass((String)"codechicken.enderstorage.common.TileFrequencyOwner");

    @Override
    public Class<?> getTargetClass() {
        return CLAZZ;
    }

    @Alias(value={"getColours"})
    @LuaCallable(returnTypes={LuaType.NUMBER, LuaType.NUMBER, LuaType.NUMBER}, description="Get the colours active on this chest or tank")
    public IMultiReturn getColors(TileEntity frequencyOwner) {
        int frequency = AdapterFrequencyOwner.getFreq(frequencyOwner);
        return OpenPeripheralAPI.wrap(1 << (frequency >> 8 & 0xF), 1 << (frequency >> 4 & 0xF), 1 << (frequency >> 0 & 0xF));
    }

    @LuaCallable(returnTypes={LuaType.STRING, LuaType.STRING, LuaType.STRING}, description="Get the colours active on this chest or tank")
    public IMultiReturn getColorNames(TileEntity frequencyOwner) {
        int frequency = AdapterFrequencyOwner.getFreq(frequencyOwner);
        return OpenPeripheralAPI.wrap(AdapterFrequencyOwner.colorToName(frequency >> 8 & 0xF), AdapterFrequencyOwner.colorToName(frequency >> 4 & 0xF), AdapterFrequencyOwner.colorToName(frequency >> 0 & 0xF));
    }

    @Alias(value={"setColours"})
    @LuaMethod(returnType=LuaType.VOID, onTick=false, description="Set the frequency of this chest or tank", args={@Arg(name="color_left", type=LuaType.NUMBER, description="The first color"), @Arg(name="color_middle", type=LuaType.NUMBER, description="The second color"), @Arg(name="color_right", type=LuaType.NUMBER, description="The third color")})
    public void setColors(TileEntity frequencyOwner, int colorLeft, int colorMiddle, int colorRight) {
        int high = AdapterFrequencyOwner.parseComputerCraftColor(colorLeft);
        int med = AdapterFrequencyOwner.parseComputerCraftColor(colorMiddle);
        int low = AdapterFrequencyOwner.parseComputerCraftColor(colorRight);
        int frequency = ((high & 0xF) << 8) + ((med & 0xF) << 4) + (low & 0xF);
        AdapterFrequencyOwner.setFreq(frequencyOwner, frequency);
    }

    @LuaCallable(description="Set the frequency of this chest or tank")
    public void setColorNames(TileEntity frequencyOwner, @Arg(name="color_left", type=LuaType.STRING) String colorLeft, @Arg(name="color_middle", type=LuaType.STRING) String colorMiddle, @Arg(name="color_right", type=LuaType.STRING) String colorRight) {
        int high = AdapterFrequencyOwner.parseColorName(colorLeft);
        int med = AdapterFrequencyOwner.parseColorName(colorMiddle);
        int low = AdapterFrequencyOwner.parseColorName(colorRight);
        int frequency = ((high & 0xF) << 8) + ((med & 0xF) << 4) + (low & 0xF);
        AdapterFrequencyOwner.setFreq(frequencyOwner, frequency);
    }

    @LuaMethod(returnType=LuaType.TABLE, onTick=false, description="Get the frequency of this chest or tank")
    public int getFrequency(TileEntity frequencyOwner) {
        return AdapterFrequencyOwner.getFreq(frequencyOwner);
    }

    @LuaMethod(returnType=LuaType.VOID, onTick=false, description="Set the frequency of this chest or tank", args={@Arg(name="frequency", type=LuaType.NUMBER, description="A single color that represents all three colours on this chest or tank")})
    public void setFrequency(TileEntity frequencyOwner, int frequency) {
        AdapterFrequencyOwner.setFreq(frequencyOwner, frequency);
    }

    private static int getFreq(TileEntity frequencyOwner) {
        return (Integer)ReflectionHelper.getProperty(CLAZZ, (Object)frequencyOwner, (String[])new String[]{"freq"});
    }

    private static void setFreq(TileEntity frequencyOwner, int frequency) {
        Preconditions.checkElementIndex((int)frequency, (int)4096, (String)"frequency");
        ReflectionHelper.call((Object)frequencyOwner, (String)"setFreq", (Object[])new Object[]{ReflectionHelper.primitive((int)frequency)});
    }

    private static int parseComputerCraftColor(int bitmask) {
        ColorUtils.ColorMeta meta = ColorUtils.bitmaskToColor((int)bitmask);
        Preconditions.checkNotNull((Object)meta, (String)"Invalid color %sb", (Object[])new Object[]{Integer.toBinaryString(bitmask)});
        return meta.vanillaId;
    }

    private static int parseColorName(String name) {
        ColorUtils.ColorMeta meta = ColorUtils.nameToColor((String)name);
        Preconditions.checkNotNull((Object)meta, (String)"Invalid color name %s", (Object[])new Object[]{name});
        return ~meta.vanillaId & 0xF;
    }

    private static String colorToName(int color) {
        ColorUtils.ColorMeta meta = ColorUtils.vanillaToColor((int)(~color & 0xF));
        Preconditions.checkNotNull((Object)meta, (String)"Invalid color id %s", (Object[])new Object[]{color});
        return meta.name;
    }
}

