/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.computercraft;

import com.google.common.collect.Maps;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Vec3;
import openmods.utils.ReflectionHelper;
import openperipheral.TypeConversionRegistry;
import openperipheral.api.IIntegrationModule;

public class ModuleComputerCraft
implements IIntegrationModule {
    public static final ReflectionHelper.SafeClassLoad API_CLASS = ReflectionHelper.safeLoad((String)"dan200.computercraft.ComputerCraft");
    public static final ReflectionHelper.SafeClassLoad PRINTOUT_CLASS = ReflectionHelper.safeLoad((String)"dan200.computercraft.shared.media.items.ItemPrintout");
    public static final ReflectionHelper.SafeClassLoad COMPUTER_ITEM_CLASS = ReflectionHelper.safeLoad((String)"dan200.computercraft.shared.computer.items.IComputerItem");
    public static final ReflectionHelper.SafeClassLoad TURTLE_ITEM_CLASS = ReflectionHelper.safeLoad((String)"dan200.computercraft.shared.turtle.items.ITurtleItem");

    @Override
    public String getModId() {
        return "ComputerCraft";
    }

    @Override
    public void init() {
        PRINTOUT_CLASS.load();
        COMPUTER_ITEM_CLASS.load();
        TURTLE_ITEM_CLASS.load();
    }

    @Override
    public void appendEntityInfo(Map<String, Object> map, Entity entity, Vec3 relativePos) {
    }

    @Override
    public void appendItemInfo(Map<String, Object> map, ItemStack stack) {
        Item item = stack.func_77973_b();
        if (COMPUTER_ITEM_CLASS.get().isInstance(item)) {
            ModuleComputerCraft.addComputerInfo(map, stack, item);
        }
        if (item instanceof IMedia) {
            ModuleComputerCraft.addDiskInfo(map, stack, (IMedia)item);
        } else {
            IMedia media = (IMedia)ReflectionHelper.callStatic((Class)API_CLASS.get(), (String)"getMedia", (Object[])new Object[]{stack});
            if (media != null) {
                ModuleComputerCraft.addDiskInfo(map, stack, media);
            }
        }
        if (PRINTOUT_CLASS.get().isInstance(item)) {
            ModuleComputerCraft.addPrintoutInfo(map, stack, item);
        }
    }

    private static void addPrintoutInfo(Map<String, Object> map, ItemStack stack, Item item) {
        HashMap printoutMap = Maps.newHashMap();
        printoutMap.put("title", ReflectionHelper.call((Object)item, (String)"getTitle", (Object[])new Object[]{stack}));
        printoutMap.put("pages", ReflectionHelper.call((Object)item, (String)"getPageCount", (Object[])new Object[]{stack}));
        String[] texts = (String[])ReflectionHelper.call((Object)item, (String)"getText", (Object[])new Object[]{stack});
        printoutMap.put("text", TypeConversionRegistry.toLua(texts));
        map.put("printout", printoutMap);
    }

    private static void addDiskInfo(Map<String, Object> map, ItemStack stack, IMedia item) {
        String record;
        HashMap diskInfo = Maps.newHashMap();
        String label = item.getLabel(stack);
        if (label != null) {
            diskInfo.put("label", label);
        }
        if ((record = item.getAudioRecordName(stack)) != null) {
            diskInfo.put("record", record);
        }
        map.put("disk", diskInfo);
    }

    private static void addComputerInfo(Map<String, Object> map, ItemStack stack, Item item) {
        HashMap computerInfo = Maps.newHashMap();
        int computerID = (Integer)ReflectionHelper.call((Object)item, (String)"getComputerID", (Object[])new Object[]{stack});
        if (computerID >= 0) {
            computerInfo.put("id", computerID);
            String label = (String)ReflectionHelper.call((Object)item, (String)"getLabel", (Object[])new Object[]{stack});
            if (label != null) {
                computerInfo.put("label", label);
            }
        }
        computerInfo.put("type", ReflectionHelper.call((Object)item, (String)"getFamily", (Object[])new Object[]{stack}));
        if (TURTLE_ITEM_CLASS.get().isInstance(item)) {
            ModuleComputerCraft.addTurtleInfo(computerInfo, stack, item);
        }
        map.put("computer", computerInfo);
    }

    private static void addTurtleInfo(Map<String, Object> map, ItemStack stack, Item item) {
        ModuleComputerCraft.addSideInfo(map, "left", (ITurtleUpgrade)ReflectionHelper.call((Object)item, (String)"getUpgrade", (Object[])new Object[]{stack, TurtleSide.Left}));
        ModuleComputerCraft.addSideInfo(map, "right", (ITurtleUpgrade)ReflectionHelper.call((Object)item, (String)"getUpgrade", (Object[])new Object[]{stack, TurtleSide.Right}));
        int fuelLevel = (Integer)ReflectionHelper.call((Object)item, (String)"getFuelLevel", (Object[])new Object[]{stack});
        map.put("fuel", fuelLevel);
    }

    private static void addSideInfo(Map<String, Object> map, String side, ITurtleUpgrade upgrade) {
        if (upgrade != null) {
            HashMap upgradeMap = Maps.newHashMap();
            upgradeMap.put("adjective", upgrade.getAdjective());
            upgradeMap.put("type", upgrade.getType().toString());
            map.put(side, upgradeMap);
        }
    }
}

