/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.buildcraft;

import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import net.minecraftforge.common.ForgeDirection;
import openperipheral.api.Arg;
import openperipheral.api.IPeripheralAdapter;
import openperipheral.api.LuaMethod;
import openperipheral.api.LuaType;

public class AdapterPowerReceptor
implements IPeripheralAdapter {
    @Override
    public Class<?> getTargetClass() {
        return IPowerReceptor.class;
    }

    @LuaMethod(returnType=LuaType.NUMBER, description="Get the activation MJ for this block", args={@Arg(name="direction", type=LuaType.STRING, description="The side of the block that you're interested in")})
    public Float getActivationEnergy(IPowerReceptor powerReceptor, ForgeDirection direction) {
        PowerHandler.PowerReceiver powerReceiver = powerReceptor.getPowerReceiver(direction);
        if (powerReceiver == null) {
            return null;
        }
        return Float.valueOf(powerReceiver.getActivationEnergy());
    }

    @LuaMethod(returnType=LuaType.NUMBER, description="Get the MJ stored for this block", args={@Arg(name="direction", type=LuaType.STRING, description="The side of the block that you're interested in")})
    public Float getMJStored(IPowerReceptor powerReceptor, ForgeDirection direction) {
        PowerHandler.PowerReceiver powerReceiver = powerReceptor.getPowerReceiver(direction);
        if (powerReceiver == null) {
            return null;
        }
        return Float.valueOf(powerReceiver.getEnergyStored());
    }

    @LuaMethod(returnType=LuaType.NUMBER, description="Get the max MJ received", args={@Arg(name="direction", type=LuaType.STRING, description="The side of the block that you're interested in")})
    public Float getMaxMJReceived(IPowerReceptor powerReceptor, ForgeDirection direction) {
        PowerHandler.PowerReceiver powerReceiver = powerReceptor.getPowerReceiver(direction);
        if (powerReceiver == null) {
            return null;
        }
        return Float.valueOf(powerReceiver.getMaxEnergyReceived());
    }

    @LuaMethod(returnType=LuaType.NUMBER, description="Get the max MJ stored", args={@Arg(name="direction", type=LuaType.STRING, description="The side of the block that you're interested in")})
    public Float getMaxMJStored(IPowerReceptor powerReceptor, ForgeDirection direction) {
        PowerHandler.PowerReceiver powerReceiver = powerReceptor.getPowerReceiver(direction);
        if (powerReceiver == null) {
            return null;
        }
        return Float.valueOf(powerReceiver.getMaxEnergyStored());
    }

    @LuaMethod(returnType=LuaType.NUMBER, description="Get the min MJ received", args={@Arg(name="direction", type=LuaType.STRING, description="The side of the block that you're interested in")})
    public Float getMinMJReceived(IPowerReceptor powerReceptor, ForgeDirection direction) {
        PowerHandler.PowerReceiver powerReceiver = powerReceptor.getPowerReceiver(direction);
        if (powerReceiver == null) {
            return null;
        }
        return Float.valueOf(powerReceiver.getMinEnergyReceived());
    }
}

