/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.appeng;

import appeng.api.IAEItemStack;
import appeng.api.IItemList;
import appeng.api.Util;
import appeng.api.WorldCoord;
import appeng.api.exceptions.AppEngTileMissingException;
import appeng.api.me.tiles.IGridTileEntity;
import appeng.api.me.util.IGridInterface;
import appeng.api.me.util.IMEInventoryHandler;
import com.google.common.base.Preconditions;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import openmods.utils.InventoryUtils;
import openperipheral.api.Arg;
import openperipheral.api.IPeripheralAdapter;
import openperipheral.api.LuaMethod;
import openperipheral.api.LuaType;

public class AdapterGridTileEntity
implements IPeripheralAdapter {
    @Override
    public Class<?> getTargetClass() {
        return IGridTileEntity.class;
    }

    private static IGridInterface getGrid(IGridTileEntity te) {
        IGridInterface grid = te.getGrid();
        Preconditions.checkNotNull((Object)grid, (Object)"No valid grid");
        return grid;
    }

    private static IMEInventoryHandler getCell(IGridTileEntity te) {
        IGridInterface grid = AdapterGridTileEntity.getGrid(te);
        IMEInventoryHandler cell = grid.getCellArray();
        Preconditions.checkNotNull((Object)grid, (Object)"No valid cell");
        return cell;
    }

    @LuaMethod(description="Request crafting of a specific item", returnType=LuaType.VOID, args={@Arg(type=LuaType.TABLE, name="stack", description="A table representing the item stack")})
    public void requestCrafting(IGridTileEntity te, ItemStack stack) throws AppEngTileMissingException {
        AdapterGridTileEntity.getGrid(te).craftingRequest(stack);
    }

    @LuaMethod(description="Extract an item", returnType=LuaType.NUMBER, args={@Arg(type=LuaType.TABLE, name="stack", description="A table representing the item stack"), @Arg(type=LuaType.STRING, name="direction", description="The direction of the chest relative to the wrapped peripheral")})
    public long extractItem(IGridTileEntity te, ItemStack stack, ForgeDirection direction) {
        IMEInventoryHandler cell = AdapterGridTileEntity.getCell(te);
        WorldCoord coord = te.getLocation();
        IInventory targetInventory = InventoryUtils.getInventory((World)te.getWorld(), (int)coord.x, (int)coord.y, (int)coord.z, (ForgeDirection)direction);
        Preconditions.checkNotNull((Object)targetInventory, (Object)"Target inventory does not exists");
        IAEItemStack request = Util.createItemStack((ItemStack)stack);
        Preconditions.checkState((request != null && request.getItem() != null ? 1 : 0) != 0, (Object)"Invalid item");
        IAEItemStack returned = cell.extractItems(request);
        Preconditions.checkState((returned != null ? 1 : 0) != 0, (Object)"No item found");
        int requestAmount = stack.field_77994_a;
        ItemStack returnedStack = returned.getItemStack();
        InventoryUtils.insertItemIntoInventory((IInventory)targetInventory, (ItemStack)returnedStack, (ForgeDirection)direction.getOpposite(), (int)-1);
        IAEItemStack giveBack = Util.createItemStack((ItemStack)returnedStack.func_77946_l());
        cell.addItems(giveBack);
        return (long)requestAmount - giveBack.getStackSize();
    }

    @LuaMethod(description="Insert an item back into the system", returnType=LuaType.NUMBER, args={@Arg(type=LuaType.NUMBER, name="slot", description="The slot you wish to send"), @Arg(type=LuaType.NUMBER, name="amount", description="The amount you want to send"), @Arg(type=LuaType.STRING, name="direction", description="The direction of the chest relative to the wrapped peripheral")})
    public long insertItem(IGridTileEntity te, int slot, int amount, ForgeDirection direction) {
        IMEInventoryHandler cell = AdapterGridTileEntity.getCell(te);
        WorldCoord coord = te.getLocation();
        IInventory targetInventory = InventoryUtils.getInventory((World)te.getWorld(), (int)coord.x, (int)coord.y, (int)coord.z, (ForgeDirection)direction);
        Preconditions.checkNotNull((Object)targetInventory, (Object)"Target inventory does not exists");
        Preconditions.checkArgument((--slot >= 0 && slot < targetInventory.func_70302_i_() ? 1 : 0) != 0, (Object)"Slot is out of range");
        if (amount <= 0) {
            return 0L;
        }
        ItemStack stack = targetInventory.func_70301_a(slot);
        if (stack == null) {
            return 0L;
        }
        amount = Math.min(amount, stack.field_77994_a);
        ItemStack sendStack = stack.func_77946_l();
        sendStack.field_77994_a = amount;
        IAEItemStack request = Util.createItemStack((ItemStack)sendStack);
        IAEItemStack remaining = cell.addItems(request);
        long remainingCount = remaining != null ? remaining.getStackSize() : 0L;
        long sent = (long)amount - remainingCount;
        stack.field_77994_a = (int)((long)stack.field_77994_a - sent);
        if (stack.field_77994_a <= 0) {
            targetInventory.func_70299_a(slot, null);
        }
        return sent;
    }

    @LuaMethod(description="Get the total total item types stored", returnType=LuaType.NUMBER)
    public long getTotalItemTypes(IGridTileEntity te) {
        return AdapterGridTileEntity.getCell(te).getTotalItemTypes();
    }

    @LuaMethod(description="Get the priority of this machine", returnType=LuaType.NUMBER)
    public int getPriority(IGridTileEntity te) {
        return AdapterGridTileEntity.getCell(te).getPriority();
    }

    @LuaMethod(description="Can this machine hold any new items?", returnType=LuaType.NUMBER)
    public boolean canHoldNewItem(IGridTileEntity te) {
        return AdapterGridTileEntity.getCell(te).canHoldNewItem();
    }

    @LuaMethod(description="Get the amount of free bytes", returnType=LuaType.NUMBER)
    public long getFreeBytes(IGridTileEntity te) {
        return AdapterGridTileEntity.getCell(te).freeBytes();
    }

    @LuaMethod(description="Get a list of the available items", returnType=LuaType.TABLE)
    public IItemList getAvailableItems(IGridTileEntity te) {
        return AdapterGridTileEntity.getCell(te).getAvailableItems();
    }

    @LuaMethod(description="Check to see if the network contains an item type", returnType=LuaType.BOOLEAN, args={@Arg(type=LuaType.NUMBER, name="itemId", description="The item id"), @Arg(type=LuaType.NUMBER, name="dmgValue", description="The item dmg value")})
    public boolean containsItemType(IGridTileEntity te, int itemId, int dmgValue) {
        return this.countOfItemType(te, itemId, dmgValue) > 0L;
    }

    @LuaMethod(description="Count the amount of a certain item type", returnType=LuaType.NUMBER, args={@Arg(type=LuaType.NUMBER, name="itemId", description="The item id"), @Arg(type=LuaType.NUMBER, name="dmgValue", description="The item dmg value")})
    public long countOfItemType(IGridTileEntity te, int itemId, int dmgValue) {
        IMEInventoryHandler cell = AdapterGridTileEntity.getCell(te);
        long c = 0L;
        for (IAEItemStack stack : cell.getAvailableItems()) {
            if (stack.getItemID() != itemId || stack.getItemDamage() != dmgValue) continue;
            c += stack.getStackSize();
        }
        return c;
    }

    @LuaMethod(description="Get a list of the preformatted items", returnType=LuaType.TABLE)
    public List<ItemStack> getPreformattedItems(IGridTileEntity te) {
        return AdapterGridTileEntity.getCell(te).getPreformattedItems();
    }

    @LuaMethod(description="Is fuzzy preformatted", returnType=LuaType.BOOLEAN)
    public boolean isFuzzyPreformatted(IGridTileEntity te) {
        return AdapterGridTileEntity.getCell(te).isFuzzyPreformatted();
    }

    @LuaMethod(description="Is preformatted", returnType=LuaType.BOOLEAN)
    public boolean isPreformatted(IGridTileEntity te) {
        return AdapterGridTileEntity.getCell(te).isPreformatted();
    }

    @LuaMethod(description="Get the remaining item count", returnType=LuaType.NUMBER)
    public long getRemainingItemCount(IGridTileEntity te) {
        return AdapterGridTileEntity.getCell(te).remainingItemCount();
    }

    @LuaMethod(description="Get the remaining item type count", returnType=LuaType.NUMBER)
    public long getRemainingItemTypes(IGridTileEntity te) {
        return AdapterGridTileEntity.getCell(te).remainingItemTypes();
    }

    @LuaMethod(description="Get the amount of stored items", returnType=LuaType.NUMBER)
    public long getStoredItemCount(IGridTileEntity te) {
        return AdapterGridTileEntity.getCell(te).storedItemCount();
    }

    @LuaMethod(description="Get the amount of stored item types", returnType=LuaType.NUMBER)
    public long getStoredItemTypes(IGridTileEntity te) {
        return AdapterGridTileEntity.getCell(te).storedItemTypes();
    }

    @LuaMethod(description="Get the total bytes", returnType=LuaType.NUMBER)
    public long getTotalBytes(IGridTileEntity te) {
        return AdapterGridTileEntity.getCell(te).totalBytes();
    }

    @LuaMethod(description="Get the unused item count", returnType=LuaType.NUMBER)
    public long getUnusedItemCount(IGridTileEntity te) {
        return AdapterGridTileEntity.getCell(te).unusedItemCount();
    }

    @LuaMethod(description="Get the unused bytes", returnType=LuaType.NUMBER)
    public long getUnusedBytes(IGridTileEntity te) {
        return AdapterGridTileEntity.getCell(te).usedBytes();
    }
}

