/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.appeng;

import appeng.api.IAEItemStack;
import appeng.api.IItemList;
import appeng.api.me.tiles.ICellProvider;
import appeng.api.me.util.IMEInventoryHandler;
import com.google.common.base.Preconditions;
import java.util.List;
import net.minecraft.item.ItemStack;
import openperipheral.api.Arg;
import openperipheral.api.IPeripheralAdapter;
import openperipheral.api.LuaCallable;
import openperipheral.api.LuaMethod;
import openperipheral.api.LuaType;

public class AdapterCellProvider
implements IPeripheralAdapter {
    @Override
    public Class<?> getTargetClass() {
        return ICellProvider.class;
    }

    private static IMEInventoryHandler getCell(ICellProvider provider) {
        IMEInventoryHandler cell = provider.provideCell();
        Preconditions.checkNotNull((Object)cell, (Object)"No valid cell");
        return cell;
    }

    @LuaCallable(description="Is block valid", returnTypes={LuaType.BOOLEAN})
    public boolean isValid(ICellProvider provider) {
        return provider.provideCell() != null;
    }

    @LuaMethod(description="Get the total total item types stored", returnType=LuaType.NUMBER)
    public long getTotalItemTypes(ICellProvider provider) {
        return AdapterCellProvider.getCell(provider).getTotalItemTypes();
    }

    @LuaMethod(description="Get the priority of this machine", returnType=LuaType.NUMBER)
    public int getPriority(ICellProvider provider) {
        return AdapterCellProvider.getCell(provider).getPriority();
    }

    @LuaMethod(description="Can this machine hold any new items?", returnType=LuaType.NUMBER)
    public boolean canHoldNewItem(ICellProvider provider) {
        return AdapterCellProvider.getCell(provider).canHoldNewItem();
    }

    @LuaMethod(description="Get the amount of free bytes", returnType=LuaType.NUMBER)
    public long getFreeBytes(ICellProvider provider) {
        return AdapterCellProvider.getCell(provider).freeBytes();
    }

    @LuaMethod(description="Get a list of the available items", returnType=LuaType.TABLE)
    public IItemList getAvailableItems(ICellProvider provider) {
        return AdapterCellProvider.getCell(provider).getAvailableItems();
    }

    @LuaMethod(description="Check to see if the network contains an item type", returnType=LuaType.BOOLEAN, args={@Arg(type=LuaType.NUMBER, name="itemId", description="The item id"), @Arg(type=LuaType.NUMBER, name="dmgValue", description="The item dmg value")})
    public boolean containsItemType(ICellProvider provider, int itemId, int dmgValue) {
        return this.countOfItemType(provider, itemId, dmgValue) > 0L;
    }

    @LuaMethod(description="Count the amount of a certain item type", returnType=LuaType.NUMBER, args={@Arg(type=LuaType.NUMBER, name="itemId", description="The item id"), @Arg(type=LuaType.NUMBER, name="dmgValue", description="The item dmg value")})
    public long countOfItemType(ICellProvider provider, int itemId, int dmgValue) {
        IMEInventoryHandler cell = AdapterCellProvider.getCell(provider);
        long c = 0L;
        for (IAEItemStack stack : cell.getAvailableItems()) {
            if (stack.getItemID() != itemId || stack.getItemDamage() != dmgValue) continue;
            c += stack.getStackSize();
        }
        return c;
    }

    @LuaMethod(description="Get the name of this cell", returnType=LuaType.STRING)
    public String getName(ICellProvider provider) {
        return AdapterCellProvider.getCell(provider).getName();
    }

    @LuaMethod(description="Get a list of the preformatted items", returnType=LuaType.TABLE)
    public List<ItemStack> getPreformattedItems(ICellProvider provider) {
        return AdapterCellProvider.getCell(provider).getPreformattedItems();
    }

    @LuaMethod(description="Is fuzzy preformatted", returnType=LuaType.BOOLEAN)
    public boolean isFuzzyPreformatted(ICellProvider provider) {
        return AdapterCellProvider.getCell(provider).isFuzzyPreformatted();
    }

    @LuaMethod(description="Is preformatted", returnType=LuaType.BOOLEAN)
    public boolean isPreformatted(ICellProvider provider) {
        return AdapterCellProvider.getCell(provider).isPreformatted();
    }

    @LuaMethod(description="Get the remaining item count", returnType=LuaType.NUMBER)
    public long getRemainingItemCount(ICellProvider provider) {
        return AdapterCellProvider.getCell(provider).remainingItemCount();
    }

    @LuaMethod(description="Get the remaining item type count", returnType=LuaType.NUMBER)
    public long getRemainingItemTypes(ICellProvider provider) {
        return AdapterCellProvider.getCell(provider).remainingItemTypes();
    }

    @LuaMethod(description="Get the amount of stored items", returnType=LuaType.NUMBER)
    public long getStoredItemCount(ICellProvider provider) {
        return AdapterCellProvider.getCell(provider).storedItemCount();
    }

    @LuaMethod(description="Get the amount of stored item types", returnType=LuaType.NUMBER)
    public long getStoredItemTypes(ICellProvider provider) {
        return AdapterCellProvider.getCell(provider).storedItemTypes();
    }

    @LuaMethod(description="Get the total bytes", returnType=LuaType.NUMBER)
    public long getTotalBytes(ICellProvider provider) {
        return AdapterCellProvider.getCell(provider).totalBytes();
    }

    @LuaMethod(description="Get the unused item count", returnType=LuaType.NUMBER)
    public long getUnusedItemCount(ICellProvider provider) {
        return AdapterCellProvider.getCell(provider).unusedItemCount();
    }

    @LuaMethod(description="Get the unused bytes", returnType=LuaType.NUMBER)
    public long getUnusedBytes(ICellProvider provider) {
        return AdapterCellProvider.getCell(provider).usedBytes();
    }
}

