/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.converter;

import com.google.common.collect.Maps;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import openperipheral.TypeConversionRegistry;
import openperipheral.api.ITypeConverter;

public class ConverterArray
implements ITypeConverter {
    @Override
    public Object fromLua(Object o, Class<?> required) {
        if (o instanceof Map && required.isArray()) {
            int index;
            Map m = (Map)o;
            Class<?> component = required.getComponentType();
            if (m.isEmpty()) {
                return Array.newInstance(component, 0);
            }
            int indexMin = Integer.MAX_VALUE;
            int indexMax = Integer.MIN_VALUE;
            HashMap tmp = Maps.newHashMap();
            for (Map.Entry e : m.entrySet()) {
                Object k = e.getKey();
                if (!(k instanceof Number)) {
                    return null;
                }
                index = ((Number)k).intValue();
                if (index < indexMin) {
                    indexMin = index;
                }
                if (index > indexMax) {
                    indexMax = index;
                }
                tmp.put(index, e.getValue());
            }
            int size = indexMax - indexMin + 1;
            if (size != tmp.size() || indexMin != 0 && indexMin != 1) {
                return null;
            }
            Object result = Array.newInstance(component, size);
            int i = 0;
            index = indexMin;
            while (i < size) {
                Object in = tmp.get(index);
                Object out = TypeConversionRegistry.fromLua(in, component);
                if (out == null) {
                    return null;
                }
                Array.set(result, i, out);
                ++i;
                ++index;
            }
            return result;
        }
        return null;
    }

    @Override
    public Object toLua(Object o) {
        if (o.getClass().isArray()) {
            HashMap ret = Maps.newHashMap();
            int length = Array.getLength(o);
            for (int i = 0; i < length; ++i) {
                Object value = Array.get(o, i);
                ret.put(i + 1, TypeConversionRegistry.toLua(value));
            }
            return ret;
        }
        return null;
    }
}

