/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.api;

import cpw.mods.fml.common.FMLLog;
import dan200.computercraft.api.lua.ILuaObject;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.tileentity.TileEntity;
import openperipheral.api.IIntegrationModule;
import openperipheral.api.IMultiReturn;
import openperipheral.api.IObjectAdapter;
import openperipheral.api.IPeripheralAdapter;
import openperipheral.api.ITypeConverter;

public class OpenPeripheralAPI {
    public static final Logger logger = Logger.getLogger("OpenPeripheral API");

    public static boolean register(IPeripheralAdapter adapter) {
        return OpenPeripheralAPI.callWithoutReturn("openperipheral.adapter.AdapterManager", "addPeripheralAdapter", IPeripheralAdapter.class, adapter);
    }

    public static boolean register(IObjectAdapter adapter) {
        return OpenPeripheralAPI.callWithoutReturn("openperipheral.adapter.AdapterManager", "addObjectAdapter", IPeripheralAdapter.class, adapter);
    }

    public static boolean register(ITypeConverter converter) {
        return OpenPeripheralAPI.callWithoutReturn("openperipheral.TypeConversionRegistry", "registerTypeConverter", ITypeConverter.class, converter);
    }

    public static boolean register(IIntegrationModule module) {
        return OpenPeripheralAPI.callWithoutReturn("openperipheral.IntegrationModuleRegistry", "registerModule", IIntegrationModule.class, module);
    }

    public static boolean createAdapter(Class<? extends TileEntity> cls) {
        return OpenPeripheralAPI.callWithoutReturn("openperipheral.adapter.AdapterManager", "addInlinePeripheralAdapter", Class.class, cls);
    }

    public static ILuaObject createWrapper(Object obj) {
        return OpenPeripheralAPI.callWithReturn("openperipheral.adapter.AdapterManager", "wrapObject", Object.class, obj, ILuaObject.class);
    }

    public static IPeripheral createHostedPeripheral(Object target) {
        return OpenPeripheralAPI.callWithReturn("openperipheral.adapter.PeripheralHandlers", "createPeripheral", Object.class, target, IPeripheral.class);
    }

    private static Method getMethod(String klazzName, String methodName, Class<?> argType) throws Exception {
        Class<?> klazz = Class.forName(klazzName);
        return klazz.getMethod(methodName, argType);
    }

    private static <A> boolean callWithoutReturn(String klazzName, String methodName, Class<? extends A> argType, A argValue) {
        try {
            Method method = OpenPeripheralAPI.getMethod(klazzName, methodName, argType);
            method.invoke(null, argValue);
            return true;
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, String.format("Exception while calling method '%s'", methodName), t);
            return false;
        }
    }

    private static <A, T> T callWithReturn(String klazzName, String methodName, Class<? extends A> argType, A argValue, Class<? extends T> returnType) {
        Object result;
        try {
            Method method = OpenPeripheralAPI.getMethod(klazzName, methodName, argType);
            result = method.invoke(null, argValue);
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, String.format("Exception while calling method '%s'", methodName), t);
            return null;
        }
        if (result == null || returnType.isInstance(result)) {
            return (T)result;
        }
        logger.log(Level.WARNING, String.format("Method '%s' return type '%s' cannot be cast to '%s'", methodName, result.getClass(), returnType));
        return null;
    }

    public static IMultiReturn wrap(final Object ... args) {
        return new IMultiReturn(){

            @Override
            public Object[] getObjects() {
                return args;
            }
        };
    }

    static {
        logger.setParent(FMLLog.getLogger());
    }
}

