/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.peripheral;

import com.google.common.base.Preconditions;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import openperipheral.adapter.IDescriptable;
import openperipheral.adapter.PropertyListBuilder;
import openperipheral.adapter.method.MethodDeclaration;
import openperipheral.adapter.object.IObjectMethodExecutor;
import openperipheral.adapter.peripheral.ExecutionStrategy;
import openperipheral.adapter.peripheral.IPeripheralMethodExecutor;
import openperipheral.adapter.peripheral.PeripheralAdapterWrapper;

public class PeripheralInlineAdapterWrapper
extends PeripheralAdapterWrapper
implements PropertyListBuilder.IPropertyExecutorFactory<IPeripheralMethodExecutor> {
    public PeripheralInlineAdapterWrapper(Class<?> targetClass) {
        super(targetClass, targetClass);
    }

    @Override
    protected IPeripheralMethodExecutor createDirectExecutor(MethodDeclaration method, ExecutionStrategy strategy, Map<String, Method> proxyArgs) {
        return new InlineMethodExecutor(method, strategy, proxyArgs);
    }

    @Override
    protected void nameDefaultParameters(MethodDeclaration decl) {
        decl.nameJavaArg(0, "computer");
    }

    @Override
    protected void validateArgTypes(MethodDeclaration decl) {
        decl.declareJavaArgType("computer", IComputerAccess.class);
        decl.declareJavaArgType("context", ILuaContext.class);
    }

    @Override
    protected IPeripheralMethodExecutor adaptObjectExecutor(final Method targetProvider, final IObjectMethodExecutor executor) {
        Preconditions.checkArgument((boolean)Arrays.equals(targetProvider.getParameterTypes(), new Class[0]));
        return new IPeripheralMethodExecutor(){

            @Override
            public boolean isSynthetic() {
                return false;
            }

            @Override
            public IDescriptable getWrappedMethod() {
                return executor.getWrappedMethod();
            }

            @Override
            public Object[] execute(IComputerAccess computer, ILuaContext context, Object target, Object[] args) throws Exception {
                Object executorTarget = targetProvider.invoke(target, new Object[0]);
                return executor.execute(context, executorTarget, args);
            }
        };
    }

    @Override
    public IPeripheralMethodExecutor createExecutor(PropertyListBuilder.FieldContext context) {
        return new PeripheralPropertyExecutor(context);
    }

    @Override
    protected List<IPeripheralMethodExecutor> buildMethodList() {
        List<IPeripheralMethodExecutor> result = super.buildMethodList();
        PropertyListBuilder.buildPropertyList(this.targetCls, this, result);
        return result;
    }

    private static class PeripheralPropertyExecutor
    extends PropertyListBuilder.PropertyExecutor
    implements IPeripheralMethodExecutor {
        protected PeripheralPropertyExecutor(PropertyListBuilder.FieldContext context) {
            super(context);
        }

        @Override
        public Object[] execute(IComputerAccess computer, ILuaContext context, Object target, Object[] args) throws Exception {
            return this.call(target, args);
        }
    }

    private static class InlineMethodExecutor
    extends PeripheralAdapterWrapper.PeripheralMethodExecutor {
        public InlineMethodExecutor(MethodDeclaration method, ExecutionStrategy strategy, Map<String, Method> proxyArgs) {
            super(method, strategy, proxyArgs);
        }

        @Override
        protected MethodDeclaration.CallWrap createWrapper(IComputerAccess computer, ILuaContext context, Object target, Object[] luaArgs) {
            return this.method.createWrapper(target).setJavaArg("computer", computer).setJavaArg("context", context).setLuaArgs(luaArgs);
        }
    }
}

