/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.peripheral;

import com.google.common.base.Preconditions;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import openperipheral.adapter.IDescriptable;
import openperipheral.adapter.method.MethodDeclaration;
import openperipheral.adapter.object.IObjectMethodExecutor;
import openperipheral.adapter.peripheral.ExecutionStrategy;
import openperipheral.adapter.peripheral.IPeripheralMethodExecutor;
import openperipheral.adapter.peripheral.PeripheralAdapterWrapper;
import openperipheral.api.IPeripheralAdapter;

public class PeripheralExternalAdapterWrapper
extends PeripheralAdapterWrapper {
    private final IPeripheralAdapter adapter;

    public PeripheralExternalAdapterWrapper(IPeripheralAdapter adapter) {
        super(adapter.getClass(), adapter.getTargetClass());
        this.adapter = adapter;
    }

    @Override
    protected IPeripheralMethodExecutor createDirectExecutor(MethodDeclaration method, ExecutionStrategy strategy, Map<String, Method> proxyArgs) {
        return new NormalMethodExecutor(method, strategy, proxyArgs);
    }

    @Override
    protected void nameDefaultParameters(MethodDeclaration decl) {
        decl.nameJavaArg(0, "computer");
        decl.nameJavaArg(1, "target");
    }

    @Override
    protected void validateArgTypes(MethodDeclaration decl) {
        decl.declareJavaArgType("computer", IComputerAccess.class);
        decl.declareJavaArgType("context", ILuaContext.class);
        decl.declareJavaArgType("target", this.targetCls);
    }

    @Override
    protected IPeripheralMethodExecutor adaptObjectExecutor(final Method targetProvider, final IObjectMethodExecutor executor) {
        Preconditions.checkArgument((boolean)Arrays.equals(targetProvider.getParameterTypes(), new Class[]{this.targetCls}));
        return new IPeripheralMethodExecutor(){

            @Override
            public boolean isSynthetic() {
                return false;
            }

            @Override
            public IDescriptable getWrappedMethod() {
                return executor.getWrappedMethod();
            }

            @Override
            public Object[] execute(IComputerAccess computer, ILuaContext context, Object target, Object[] args) throws Exception {
                Object executorTarget = targetProvider.invoke((Object)PeripheralExternalAdapterWrapper.this.adapter, target);
                return executor.execute(context, executorTarget, args);
            }
        };
    }

    private class NormalMethodExecutor
    extends PeripheralAdapterWrapper.PeripheralMethodExecutor {
        public NormalMethodExecutor(MethodDeclaration method, ExecutionStrategy strategy, Map<String, Method> proxyArgs) {
            super(method, strategy, proxyArgs);
        }

        @Override
        protected MethodDeclaration.CallWrap createWrapper(IComputerAccess computer, ILuaContext context, Object target, Object[] luaArgs) {
            return this.method.createWrapper(PeripheralExternalAdapterWrapper.this.adapter).setJavaArg("computer", computer).setJavaArg("target", target).setJavaArg("context", context).setLuaArgs(luaArgs);
        }
    }
}

