/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.peripheral;

import com.google.common.base.Preconditions;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import openmods.Log;
import openperipheral.adapter.AdapterManager;
import openperipheral.adapter.AdapterWrapper;
import openperipheral.adapter.IDescriptable;
import openperipheral.adapter.composed.ClassMethodsList;
import openperipheral.adapter.method.MethodDeclaration;
import openperipheral.adapter.object.IObjectMethodExecutor;
import openperipheral.adapter.peripheral.ExecutionStrategy;
import openperipheral.adapter.peripheral.IPeripheralMethodExecutor;
import openperipheral.api.Include;
import openperipheral.api.LuaMethod;
import openperipheral.api.OnTick;
import openperipheral.api.OnTickSafe;

public abstract class PeripheralAdapterWrapper
extends AdapterWrapper<IPeripheralMethodExecutor> {
    static final String ARG_TARGET = "target";
    static final String ARG_COMPUTER = "computer";
    static final String ARG_CONTEXT = "context";

    protected PeripheralAdapterWrapper(Class<?> adapterClass, Class<?> targetClass) {
        super(adapterClass, targetClass);
    }

    protected static boolean isIgnoringWarnings(AnnotatedElement element, boolean defaultValue) {
        if (element == null) {
            return defaultValue;
        }
        OnTickSafe ignore = element.getAnnotation(OnTickSafe.class);
        return ignore != null ? ignore.value() : defaultValue;
    }

    protected static boolean isOnTick(AnnotatedElement element, boolean defaultValue) {
        OnTick onTick = element.getAnnotation(OnTick.class);
        return onTick != null ? onTick.value() : defaultValue;
    }

    @Override
    protected List<IPeripheralMethodExecutor> buildMethodList() {
        final boolean defaultOnTick = PeripheralAdapterWrapper.isOnTick(this.adapterClass, false);
        boolean packageIsIgnoringWarnings = PeripheralAdapterWrapper.isIgnoringWarnings(this.adapterClass.getPackage(), false);
        final boolean classIsIgnoringWarnings = PeripheralAdapterWrapper.isIgnoringWarnings(this.adapterClass, packageIsIgnoringWarnings);
        List<IPeripheralMethodExecutor> peripheralMethods = this.buildMethodList(false, new AdapterWrapper.MethodExecutorFactory<IPeripheralMethodExecutor>(){

            @Override
            public IPeripheralMethodExecutor createExecutor(Method method, MethodDeclaration decl, Map<String, Method> proxyArgs) {
                ExecutionStrategy strategy;
                LuaMethod methodAnn = method.getAnnotation(LuaMethod.class);
                boolean onTick = methodAnn != null ? methodAnn.onTick() : PeripheralAdapterWrapper.isOnTick(method, defaultOnTick);
                ExecutionStrategy executionStrategy = strategy = onTick ? ExecutionStrategy.createOnTickStrategy(PeripheralAdapterWrapper.this.targetCls) : ExecutionStrategy.ASYNCHRONOUS;
                if (!strategy.isAlwaysSafe() && !PeripheralAdapterWrapper.isIgnoringWarnings(method, classIsIgnoringWarnings)) {
                    Log.warn((String)"Method '%s' is synchronous, but type %s does not provide world instance. Possible runtime crash!", (Object[])new Object[]{method, PeripheralAdapterWrapper.this.targetCls});
                }
                return PeripheralAdapterWrapper.this.createDirectExecutor(decl, strategy, proxyArgs);
            }
        });
        for (Method m : this.adapterClass.getMethods()) {
            Include marker = m.getAnnotation(Include.class);
            if (marker == null) continue;
            this.includeClass(peripheralMethods, m);
        }
        return peripheralMethods;
    }

    private void includeClass(List<IPeripheralMethodExecutor> result, Method targetProvider) {
        Class<?> target = targetProvider.getReturnType();
        Preconditions.checkArgument((!target.isPrimitive() ? 1 : 0) != 0, (String)"Method %s is marked with annotation 'Include', but returns primitive type", (Object[])new Object[]{targetProvider});
        ClassMethodsList<IObjectMethodExecutor> toInclude = AdapterManager.objects.getAdapterClass(target);
        for (IObjectMethodExecutor objectExecutor : toInclude.listMethods()) {
            if (objectExecutor.isSynthetic()) continue;
            result.add(this.adaptObjectExecutor(targetProvider, objectExecutor));
        }
    }

    protected abstract IPeripheralMethodExecutor createDirectExecutor(MethodDeclaration var1, ExecutionStrategy var2, Map<String, Method> var3);

    protected abstract IPeripheralMethodExecutor adaptObjectExecutor(Method var1, IObjectMethodExecutor var2);

    protected static abstract class PeripheralMethodExecutor
    implements IPeripheralMethodExecutor {
        public final MethodDeclaration method;
        public final ExecutionStrategy strategy;
        public final Map<String, Method> proxyArgs;

        protected abstract MethodDeclaration.CallWrap createWrapper(IComputerAccess var1, ILuaContext var2, Object var3, Object[] var4);

        public PeripheralMethodExecutor(MethodDeclaration method, ExecutionStrategy strategy, Map<String, Method> proxyArgs) {
            this.method = method;
            this.strategy = strategy;
            this.proxyArgs = proxyArgs;
        }

        @Override
        public IDescriptable getWrappedMethod() {
            return this.method;
        }

        @Override
        public boolean isSynthetic() {
            return false;
        }

        @Override
        public Object[] execute(IComputerAccess computer, ILuaContext context, Object target, Object[] args) throws Exception {
            MethodDeclaration.CallWrap callable = PeripheralAdapterWrapper.nameAdapterMethods(target, this.proxyArgs, this.createWrapper(computer, context, target, args));
            return this.strategy.execute(target, computer, context, callable);
        }
    }
}

