/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.peripheral;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.concurrent.Callable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import openmods.Log;
import openperipheral.TickHandler;
import openperipheral.api.IWorldProvider;
import openperipheral.util.PrettyPrint;

public abstract class ExecutionStrategy {
    private static final String SYNC_EVENT = "op_tick_sync";
    private static int currentId;
    public static final ExecutionStrategy ASYNCHRONOUS;
    private static final ExecutionStrategy ON_TICK_TILE_ENTITY;
    private static final ExecutionStrategy ON_TICK_WORLD_PROVIDER;
    private static final ExecutionStrategy ON_TICK_OTHER;

    public abstract Object[] execute(Object var1, IComputerAccess var2, ILuaContext var3, Callable<Object[]> var4) throws Exception;

    private static synchronized int getNextId() {
        return currentId++;
    }

    public boolean isAlwaysSafe() {
        return true;
    }

    public static Object[] wrap(Object ... args) {
        return args;
    }

    public static ExecutionStrategy createOnTickStrategy(Class<?> targetClass) {
        if (TileEntity.class.isAssignableFrom(targetClass)) {
            return ON_TICK_TILE_ENTITY;
        }
        if (IWorldProvider.class.isAssignableFrom(targetClass)) {
            return ON_TICK_WORLD_PROVIDER;
        }
        return ON_TICK_OTHER;
    }

    static {
        ASYNCHRONOUS = new ExecutionStrategy(){

            @Override
            public Object[] execute(Object target, IComputerAccess computer, ILuaContext context, Callable<Object[]> callable) throws Exception {
                return callable.call();
            }
        };
        ON_TICK_TILE_ENTITY = new OnTick<TileEntity>(){

            @Override
            public World getWorld(TileEntity target) {
                return target.field_70331_k;
            }
        };
        ON_TICK_WORLD_PROVIDER = new OnTick<IWorldProvider>(){

            @Override
            public World getWorld(IWorldProvider target) {
                return target.getWorld();
            }
        };
        ON_TICK_OTHER = new OnTick<Object>(){

            @Override
            public World getWorld(Object target) {
                if (target instanceof TileEntity) {
                    return ((TileEntity)target).field_70331_k;
                }
                if (target instanceof IWorldProvider) {
                    return ((IWorldProvider)target).getWorld();
                }
                throw new UnsupportedOperationException(String.format("Methods of adapter for %s cannot be synchronous", target.getClass()));
            }

            @Override
            public boolean isAlwaysSafe() {
                return false;
            }
        };
    }

    private static abstract class OnTick<T>
    extends ExecutionStrategy {
        private OnTick() {
        }

        public abstract World getWorld(T var1);

        @Override
        public Object[] execute(Object target, IComputerAccess computer, ILuaContext context, final Callable<Object[]> callable) throws Exception {
            World world = this.getWorld(target);
            Preconditions.checkNotNull((Object)world, (Object)"Trying to execute OnTick method, but no available world");
            final Responder responder = new Responder(context, computer);
            TickHandler.addTickCallback(world, new Runnable(){

                @Override
                public void run() {
                    try {
                        responder.result = (Object[])callable.call();
                    }
                    catch (Throwable e) {
                        responder.error = e;
                    }
                    responder.signalEvent();
                }
            });
            responder.waitForEvent();
            if (responder.error != null) {
                String description = PrettyPrint.getMessageForThrowable(responder.error);
                throw new RuntimeException(description, responder.error);
            }
            return responder.result;
        }
    }

    private static class Responder {
        private final ILuaContext context;
        private final IComputerAccess access;
        private boolean nobodyLovesMe;
        private final int transactionId;
        public Throwable error;
        public Object[] result;

        private Responder(ILuaContext context, IComputerAccess access) {
            this.context = context;
            this.access = access;
            this.transactionId = ExecutionStrategy.getNextId();
        }

        public void waitForEvent() throws Exception {
            while (!this.nobodyLovesMe) {
                Object[] result;
                try {
                    result = this.context.pullEvent(ExecutionStrategy.SYNC_EVENT);
                }
                catch (Throwable e) {
                    this.nobodyLovesMe = true;
                    throw Throwables.propagate((Throwable)e);
                }
                int transactionId = ((Number)result[1]).intValue();
                if (transactionId != this.transactionId) continue;
                break;
            }
        }

        public void signalEvent() {
            Preconditions.checkState((this.error != null || this.result != null ? 1 : 0) != 0, (Object)"Must set either 'error' or 'result' before firing event");
            if (this.nobodyLovesMe) {
                Log.warn((String)"Ignoring signal for transaction %s. (sob)", (Object[])new Object[]{this.transactionId});
            } else {
                try {
                    this.access.queueEvent(ExecutionStrategy.SYNC_EVENT, ExecutionStrategy.wrap(this.transactionId));
                }
                catch (Exception e) {
                    Log.warn((Throwable)e, (String)"Failed to signal response to transaction '%d'", (Object[])new Object[]{this.transactionId});
                }
            }
        }
    }
}

