/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.peripheral;

import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.Arrays;
import java.util.logging.Level;
import openmods.Log;
import openperipheral.adapter.composed.ClassMethodsList;
import openperipheral.adapter.peripheral.IPeripheralMethodExecutor;
import openperipheral.api.IAttachable;
import openperipheral.util.PeripheralUtils;
import openperipheral.util.ResourceMount;

public class AdapterPeripheral
implements IPeripheral {
    private static final String MOUNT_NAME = "openp";
    private static final IMount MOUNT = new ResourceMount();
    protected final String type;
    protected final Object targetObject;
    protected final ClassMethodsList<IPeripheralMethodExecutor> wrapped;

    public AdapterPeripheral(ClassMethodsList<IPeripheralMethodExecutor> wrapper, Object targetObject) {
        this.targetObject = targetObject;
        this.type = PeripheralUtils.getNameForTarget(targetObject);
        this.wrapped = wrapper;
    }

    public String getType() {
        return this.type;
    }

    public String[] getMethodNames() {
        return this.wrapped.methodNames;
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int index, Object[] arguments) throws Exception {
        try {
            IPeripheralMethodExecutor executor = this.wrapped.getMethod(index);
            return executor.execute(computer, context, this.targetObject, arguments);
        }
        catch (Exception e) {
            Log.log((Level)Level.FINE, (Throwable)e, (String)"Error during method %d execution on peripheral %s, args: %s", (Object[])new Object[]{index, this.type, Arrays.toString(arguments)});
            throw e;
        }
    }

    public void attach(IComputerAccess computer) {
        computer.mount(MOUNT_NAME, MOUNT);
        if (this.targetObject instanceof IAttachable) {
            ((IAttachable)this.targetObject).addComputer(computer);
        }
    }

    public void detach(IComputerAccess computer) {
        if (this.targetObject instanceof IAttachable) {
            ((IAttachable)this.targetObject).removeComputer(computer);
        }
    }

    public boolean equals(IPeripheral other) {
        return other == this;
    }
}

