/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.object;

import dan200.computercraft.api.lua.ILuaContext;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import openperipheral.adapter.AdapterWrapper;
import openperipheral.adapter.IDescriptable;
import openperipheral.adapter.PropertyListBuilder;
import openperipheral.adapter.method.MethodDeclaration;
import openperipheral.adapter.object.IObjectMethodExecutor;
import openperipheral.api.IObjectAdapter;

public abstract class ObjectAdapterWrapper
extends AdapterWrapper<IObjectMethodExecutor> {
    private static final String ARG_TARGET = "target";
    private static final String ARG_CONTEXT = "context";

    protected ObjectAdapterWrapper(Class<?> adapterClass, Class<?> targetClass) {
        super(adapterClass, targetClass);
    }

    @Override
    protected List<IObjectMethodExecutor> buildMethodList() {
        return this.buildMethodList(true, new AdapterWrapper.MethodExecutorFactory<IObjectMethodExecutor>(){

            @Override
            public IObjectMethodExecutor createExecutor(Method method, final MethodDeclaration decl, final Map<String, Method> proxyArgs) {
                return new IObjectMethodExecutor(){

                    @Override
                    public IDescriptable getWrappedMethod() {
                        return decl;
                    }

                    @Override
                    public Object[] execute(ILuaContext context, Object target, Object[] args) throws Exception {
                        return ObjectAdapterWrapper.this.createWrapper(decl, context, target, args, proxyArgs).call();
                    }

                    @Override
                    public boolean isSynthetic() {
                        return false;
                    }
                };
            }
        });
    }

    protected abstract Callable<Object[]> createWrapper(MethodDeclaration var1, ILuaContext var2, Object var3, Object[] var4, Map<String, Method> var5);

    public static class Inline
    extends ObjectAdapterWrapper
    implements PropertyListBuilder.IPropertyExecutorFactory<IObjectMethodExecutor> {
        public Inline(Class<?> targetClass) {
            super(targetClass, targetClass);
        }

        @Override
        protected void nameDefaultParameters(MethodDeclaration decl) {
            decl.nameJavaArg(0, ObjectAdapterWrapper.ARG_CONTEXT);
        }

        @Override
        protected void validateArgTypes(MethodDeclaration decl) {
            decl.declareJavaArgType(ObjectAdapterWrapper.ARG_CONTEXT, ILuaContext.class);
        }

        @Override
        protected Callable<Object[]> createWrapper(MethodDeclaration decl, ILuaContext context, Object target, Object[] args, Map<String, Method> proxyArgs) {
            return decl.createWrapper(target).setJavaArg(ObjectAdapterWrapper.ARG_CONTEXT, context).setLuaArgs(args);
        }

        @Override
        public IObjectMethodExecutor createExecutor(PropertyListBuilder.FieldContext context) {
            return new ObjectPropertyExecutor(context);
        }

        @Override
        protected List<IObjectMethodExecutor> buildMethodList() {
            List<IObjectMethodExecutor> result = super.buildMethodList();
            PropertyListBuilder.buildPropertyList(this.targetCls, this, result);
            return result;
        }
    }

    public static class External
    extends ObjectAdapterWrapper {
        private final IObjectAdapter adapter;

        public External(IObjectAdapter adapter) {
            super(adapter.getClass(), adapter.getTargetClass());
            this.adapter = adapter;
        }

        @Override
        protected void nameDefaultParameters(MethodDeclaration decl) {
            decl.nameJavaArg(0, ObjectAdapterWrapper.ARG_TARGET);
            decl.nameJavaArg(1, ObjectAdapterWrapper.ARG_CONTEXT);
        }

        @Override
        protected void validateArgTypes(MethodDeclaration decl) {
            decl.declareJavaArgType(ObjectAdapterWrapper.ARG_CONTEXT, ILuaContext.class);
            decl.declareJavaArgType(ObjectAdapterWrapper.ARG_TARGET, this.targetCls);
        }

        @Override
        protected Callable<Object[]> createWrapper(MethodDeclaration decl, ILuaContext context, Object target, Object[] args, Map<String, Method> proxyArgs) {
            return External.nameAdapterMethods(target, proxyArgs, decl.createWrapper(this.adapter).setJavaArg(ObjectAdapterWrapper.ARG_TARGET, target).setJavaArg(ObjectAdapterWrapper.ARG_CONTEXT, context).setLuaArgs(args));
        }
    }

    private static class ObjectPropertyExecutor
    extends PropertyListBuilder.PropertyExecutor
    implements IObjectMethodExecutor {
        protected ObjectPropertyExecutor(PropertyListBuilder.FieldContext context) {
            super(context);
        }

        @Override
        public Object[] execute(ILuaContext context, Object target, Object[] args) throws Exception {
            return this.call(target, args);
        }
    }
}

