/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.object;

import com.google.common.base.Preconditions;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.ILuaObject;
import openperipheral.adapter.AdapterManager;
import openperipheral.adapter.composed.ClassMethodsList;
import openperipheral.adapter.object.IObjectMethodExecutor;

public class LuaObjectWrapper {
    public static ILuaObject wrap(AdapterManager<?, IObjectMethodExecutor> manager, Object target) {
        Preconditions.checkNotNull((Object)target, (Object)"Can't wrap null");
        ClassMethodsList<IObjectMethodExecutor> adapted = manager.getAdapterClass(target.getClass());
        return LuaObjectWrapper.wrap(adapted, target);
    }

    public static ILuaObject wrap(final ClassMethodsList<IObjectMethodExecutor> adapted, final Object target) {
        return new ILuaObject(){

            public String[] getMethodNames() {
                return adapted.methodNames;
            }

            public Object[] callMethod(ILuaContext context, int method, Object[] arguments) throws Exception {
                IObjectMethodExecutor executor = (IObjectMethodExecutor)adapted.getMethod(method);
                Preconditions.checkNotNull((Object)executor, (String)"Invalid method index %s for wrapped %s", (Object[])new Object[]{method, target.getClass()});
                return executor.execute(context, target, arguments);
            }
        };
    }
}

