/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.method;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import openperipheral.adapter.method.Argument;
import openperipheral.api.LuaType;

public class VarArgument
extends Argument {
    public VarArgument(String name, String description, LuaType luaType, Class<?> javaType, int javaArgIndex) {
        super(name, description, luaType, javaType, javaArgIndex);
    }

    @Override
    protected Class<?> getArgType(Class<?> javaArgClass) {
        Preconditions.checkArgument((boolean)javaArgClass.isArray(), (Object)"Vararg type must be array");
        return javaArgClass.getComponentType();
    }

    protected void checkArgument(Object value) {
        Preconditions.checkNotNull((Object)value, (String)"Vararg parameter '%s' has null value, but is not marked as nullable", (Object[])new Object[]{this.name});
    }

    @Override
    public Object convert(Iterator<Object> args) {
        ArrayList allArgs = Lists.newArrayList(args);
        Object vararg = Array.newInstance(this.javaType, allArgs.size());
        for (int i = 0; i < allArgs.size(); ++i) {
            Object value = allArgs.get(i);
            this.checkArgument(value);
            Object converted = this.convertSingleArg(value);
            Array.set(vararg, i, converted);
        }
        return vararg;
    }

    @Override
    public Map<String, Object> describe() {
        Map<String, Object> result = super.describe();
        result.put("vararg", true);
        return result;
    }

    @Override
    public String toString() {
        return this.name + "...";
    }
}

