/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.method;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.Map;
import openperipheral.adapter.method.Argument;
import openperipheral.api.LuaType;

public class NullableArgument
extends Argument {
    public NullableArgument(String name, String description, LuaType luaType, Class<?> javaType, int javaArgIndex) {
        super(name, description, luaType, javaType, javaArgIndex);
    }

    @Override
    protected Class<?> getArgType(Class<?> javaArgClass) {
        Preconditions.checkArgument((!javaArgClass.isPrimitive() ? 1 : 0) != 0, (Object)"Nullable arguments can't be primitive");
        return super.getArgType(javaArgClass);
    }

    @Override
    public Object convert(Iterator<Object> args) {
        Preconditions.checkState((boolean)args.hasNext(), (String)"Not enough arguments, first missing: %s", (Object[])new Object[]{this.name});
        Object arg = args.next();
        return this.convertSingleArg(arg);
    }

    @Override
    public Map<String, Object> describe() {
        Map<String, Object> result = super.describe();
        result.put("nullable", true);
        return result;
    }
}

