/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.method;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import openmods.Log;
import openmods.utils.AnnotationMap;
import openmods.utils.ReflectionHelper;
import openperipheral.TypeConversionRegistry;
import openperipheral.adapter.IDescriptable;
import openperipheral.adapter.method.Argument;
import openperipheral.adapter.method.ArgumentBuilder;
import openperipheral.api.Alias;
import openperipheral.api.Arg;
import openperipheral.api.IMultiReturn;
import openperipheral.api.LuaCallable;
import openperipheral.api.LuaMethod;
import openperipheral.api.LuaType;
import openperipheral.api.Named;
import openperipheral.api.Optionals;

public class MethodDeclaration
implements IDescriptable {
    private final List<String> names;
    private final Method method;
    private final String description;
    private final LuaType[] returnTypes;
    private final boolean validateReturn;
    private final Map<String, Integer> namedArgs = Maps.newHashMap();
    private final Set<String> allowedNames = Sets.newHashSet();
    private final List<Class<?>> javaArgs;
    private final List<Argument> luaArgs;

    private static boolean checkOptional(boolean currentState, AnnotationMap annotations) {
        return currentState || annotations.get(Optionals.class) != null;
    }

    private Argument createLuaArg(ArgumentBuilder builder, AnnotationMap annotations, Class<?> javaArgType, int index) {
        Arg arg = (Arg)annotations.get(Arg.class);
        Preconditions.checkNotNull((Object)arg, (String)"Argument %d has no annotation", (Object[])new Object[]{index});
        try {
            return builder.build(arg.name(), arg.description(), arg.type(), javaArgType, index);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Argument %d from method '%s' in invalid", index, this.method), e);
        }
    }

    private static List<String> getNames(Method method, String mainName) {
        ImmutableList.Builder names = ImmutableList.builder();
        names.add((Object)mainName);
        Alias alias = method.getAnnotation(Alias.class);
        if (alias != null) {
            names.add((Object[])alias.value());
        }
        return names.build();
    }

    public MethodDeclaration(Method method, LuaMethod luaMethod) {
        int arg;
        this.method = method;
        String luaName = luaMethod.name();
        this.names = MethodDeclaration.getNames(method, "[none set]".equals(luaName) ? method.getName() : luaName);
        this.description = luaMethod.description();
        this.returnTypes = new LuaType[]{luaMethod.returnType()};
        this.validateReturn = false;
        Class<?>[] methodArgs = method.getParameterTypes();
        Arg[] declaredLuaArgs = luaMethod.args();
        Annotation[][] argsAnnotations = method.getParameterAnnotations();
        int luaArgsStart = methodArgs.length - declaredLuaArgs.length;
        boolean isVarArg = method.isVarArgs();
        Preconditions.checkArgument((luaArgsStart >= 0 ? 1 : 0) != 0, (String)"Method %s has less arguments than declared", (Object[])new Object[]{method});
        boolean isOptional = false;
        ImmutableList.Builder luaArgs = ImmutableList.builder();
        for (arg = 0; arg < declaredLuaArgs.length; ++arg) {
            boolean isLastArg = arg == declaredLuaArgs.length - 1;
            AnnotationMap annotations = new AnnotationMap(argsAnnotations[arg]);
            Arg ann = declaredLuaArgs[arg];
            annotations.put((Annotation)ann);
            int javaArgIndex = luaArgsStart + arg;
            isOptional = MethodDeclaration.checkOptional(isOptional, annotations);
            ArgumentBuilder builder = new ArgumentBuilder();
            builder.setVararg(isLastArg && isVarArg);
            builder.setOptional(isOptional);
            builder.setNullable(ann.isNullable());
            luaArgs.add((Object)this.createLuaArg(builder, annotations, methodArgs[javaArgIndex], javaArgIndex));
        }
        this.luaArgs = luaArgs.build();
        this.javaArgs = ImmutableList.copyOf((Object[])Arrays.copyOf(methodArgs, luaArgsStart));
        for (arg = 0; arg < luaArgsStart; ++arg) {
            AnnotationMap annotations = new AnnotationMap(argsAnnotations[arg]);
            Named named = (Named)annotations.get(Named.class);
            if (named != null) {
                this.namedArgs.put(named.value(), arg);
            }
            Preconditions.checkState((annotations.get(Optionals.class) == null ? 1 : 0) != 0, (String)"@Optionals does not work for java arguments (method %s)", (Object[])new Object[]{method});
        }
    }

    public MethodDeclaration(Method method, LuaCallable meta) {
        this.method = method;
        String luaName = meta.name();
        this.names = MethodDeclaration.getNames(method, "[none set]".equals(luaName) ? method.getName() : luaName);
        this.description = meta.description();
        this.returnTypes = meta.returnTypes();
        this.validateReturn = meta.validateReturn();
        if (this.validateReturn) {
            this.validateResultCount();
        }
        Class<?>[] methodArgs = method.getParameterTypes();
        Annotation[][] argsAnnotations = method.getParameterAnnotations();
        boolean isVarArg = method.isVarArgs();
        ImmutableList.Builder luaArgs = ImmutableList.builder();
        ImmutableList.Builder javaArgs = ImmutableList.builder();
        boolean isInLuaArgs = false;
        boolean isOptional = false;
        for (int i = 0; i < methodArgs.length; ++i) {
            boolean isLastArg = i == methodArgs.length - 1;
            Class<?> cls = methodArgs[i];
            AnnotationMap annotations = new AnnotationMap(argsAnnotations[i]);
            boolean isLuaArg = false;
            Arg tmp = (Arg)annotations.get(Arg.class);
            if (tmp != null) {
                isOptional = MethodDeclaration.checkOptional(isOptional, annotations);
                ArgumentBuilder builder = new ArgumentBuilder();
                builder.setVararg(isLastArg && isVarArg);
                builder.setOptional(isOptional);
                builder.setNullable(tmp.isNullable());
                luaArgs.add((Object)this.createLuaArg(builder, annotations, cls, i));
                isLuaArg = true;
                isInLuaArgs = true;
            }
            Preconditions.checkState((!isInLuaArgs || isLuaArg ? 1 : 0) != 0, (String)"Argument %s in method %s look like Java arg, but is in Lua part (perhaps missing Arg annotation?)", (Object[])new Object[]{i, method});
            Named named = (Named)annotations.get(Named.class);
            if (named != null) {
                Preconditions.checkState((!isInLuaArgs ? 1 : 0) != 0, (String)"Argument %s in method %s is Lua arg, but has Named annotation", (Object[])new Object[]{i, method});
                this.namedArgs.put(named.value(), i);
            }
            Preconditions.checkState((isInLuaArgs || annotations.get(Optionals.class) == null ? 1 : 0) != 0, (String)"@Optionals does not work for java arguments (method %s)", (Object[])new Object[]{method});
            if (isLuaArg) continue;
            javaArgs.add(cls);
        }
        this.luaArgs = luaArgs.build();
        this.javaArgs = javaArgs.build();
    }

    private void validateResultCount() {
        Class<?> javaReturn = this.method.getReturnType();
        int returnLength = this.returnTypes.length;
        for (LuaType t : this.returnTypes) {
            Preconditions.checkArgument((t != LuaType.VOID ? 1 : 0) != 0, (String)"Method '%s' declares Void as return type. Use empty list instead.", (Object[])new Object[]{this.method});
        }
        if (javaReturn == Void.TYPE) {
            Preconditions.checkArgument((returnLength == 0 ? 1 : 0) != 0, (String)"Method '%s' returns nothing, but declares at least one Lua result", (Object[])new Object[]{this.method});
        }
        if (returnLength == 0) {
            Preconditions.checkArgument((javaReturn == Void.TYPE ? 1 : 0) != 0, (String)"Method '%s' returns '%s', but declares no Lua results", (Object[])new Object[]{this.method, javaReturn});
        }
        if (returnLength > 1) {
            Preconditions.checkArgument((javaReturn == IMultiReturn.class ? 1 : 0) != 0, (String)"Method '%s' declared more than one Lua result, but returns single '%s' instead of '%s'", (Object[])new Object[]{this.method, javaReturn, IMultiReturn.class});
        }
    }

    private Object[] validateResult(Object ... result) {
        int i;
        for (i = 0; i < result.length; ++i) {
            result[i] = TypeConversionRegistry.toLua(result[i]);
        }
        if (this.validateReturn) {
            if (this.returnTypes.length == 0) {
                Preconditions.checkArgument((result.length == 1 && result[0] == null ? 1 : 0) != 0, (Object)"Returning value from null method");
            } else {
                Preconditions.checkArgument((result.length == this.returnTypes.length ? 1 : 0) != 0, (String)"Returning invalid number of values from method %s, expected %s, got %s", (Object[])new Object[]{this.method, this.returnTypes.length, result.length});
                for (i = 0; i < result.length; ++i) {
                    LuaType expected = this.returnTypes[i];
                    Class<?> expectedType = expected.getJavaType();
                    Object got = result[i];
                    Preconditions.checkArgument((got == null || expectedType.isInstance(got) || ReflectionHelper.compareTypes(expectedType, got.getClass()) ? 1 : 0) != 0, (String)"Invalid type of return value %s: expected %s, got %s", (Object[])new Object[]{i, expected, got});
                }
            }
        }
        return result;
    }

    public CallWrap createWrapper(Object target) {
        return new CallWrap(target);
    }

    public void nameJavaArg(int index, String name) {
        Preconditions.checkArgument((index < this.javaArgs.size() ? 1 : 0) != 0, (String)"Can't assign name '%s' to argument %s in method '%s'. Possible missing argument or @Freeform?", (Object[])new Object[]{name, index, this.method});
        Integer prev = this.namedArgs.put(name, index);
        Preconditions.checkArgument((prev == null || prev == index ? 1 : 0) != 0, (String)"Trying to replace '%s' mapping from  %s, got %s", (Object[])new Object[]{name, prev, index});
    }

    public void declareJavaArgType(String name, Class<?> cls) {
        this.allowedNames.add(name);
        Integer index = this.namedArgs.get(name);
        if (index != null) {
            Class<?> expected = this.javaArgs.get(index);
            Preconditions.checkArgument((boolean)expected.isAssignableFrom(cls), (String)"Invalid argument type in method %s, was %s, got %s", (Object[])new Object[]{this.method, expected, cls});
        }
    }

    public void validate() {
        Sets.SetView unknown = Sets.difference(this.namedArgs.keySet(), this.allowedNames);
        Preconditions.checkState((boolean)unknown.isEmpty(), (String)"Unknown named arg(s) %s in method '%s'. Allowed args: %s", (Object[])new Object[]{unknown, this.method, this.allowedNames});
        HashSet needed = Sets.newHashSet();
        for (int i = 0; i < this.javaArgs.size(); ++i) {
            needed.add(i);
        }
        HashSet named = Sets.newHashSet(this.namedArgs.values());
        Sets.SetView missing = Sets.difference((Set)needed, (Set)named);
        Preconditions.checkState((boolean)missing.isEmpty(), (String)"Arguments %s from method %s are not named", (Object[])new Object[]{missing, this.method});
        Sets.SetView extra = Sets.difference((Set)named, (Set)needed);
        Preconditions.checkState((boolean)missing.isEmpty(), (String)"Lua arguments %s from method %s are named", (Object[])new Object[]{extra, this.method});
    }

    @Override
    public Map<String, Object> describe() {
        HashMap result = Maps.newHashMap();
        result.put("description", this.description);
        ArrayList returns = Lists.newArrayList();
        for (LuaType t : this.returnTypes) {
            returns.add(t.toString());
        }
        result.put("returnTypes", returns);
        ArrayList args = Lists.newArrayList();
        for (Argument arg : this.luaArgs) {
            args.add(arg.describe());
        }
        result.put("args", args);
        return result;
    }

    @Override
    public String signature() {
        return "(" + Joiner.on((String)",").join(this.luaArgs) + ")";
    }

    @Override
    public List<String> getNames() {
        return this.names;
    }

    public Class<?>[] getLuaArgTypes() {
        Class[] result = new Class[this.luaArgs.size()];
        int index = 0;
        for (Argument arg : this.luaArgs) {
            result[index++] = arg.javaType;
        }
        return result;
    }

    public class CallWrap
    implements Callable<Object[]> {
        private final Object[] args;
        private final Set<Integer> isSet;
        private final Object target;

        public CallWrap(Object target) {
            this.args = new Object[MethodDeclaration.this.javaArgs.size() + MethodDeclaration.this.luaArgs.size()];
            this.isSet = Sets.newHashSet();
            this.target = target;
        }

        private CallWrap setArg(int position, Object value) {
            boolean newlyAdded = this.isSet.add(position);
            Preconditions.checkState((boolean)newlyAdded, (String)"Trying to set already defined argument %s in method %s", (Object[])new Object[]{position, MethodDeclaration.this.method});
            this.args[position] = value;
            return this;
        }

        public CallWrap setJavaArg(String name, Object value) {
            Integer position = (Integer)MethodDeclaration.this.namedArgs.get(name);
            if (position != null) {
                this.setArg(position, value);
            }
            return this;
        }

        public CallWrap setLuaArgs(Object[] luaValues) {
            UnmodifiableIterator it = Iterators.forArray((Object[])luaValues);
            try {
                for (Argument arg : MethodDeclaration.this.luaArgs) {
                    Object value = arg.convert((Iterator<Object>)it);
                    this.setArg(arg.javaArgIndex, value);
                }
                Preconditions.checkState((!it.hasNext() ? 1 : 0) != 0, (Object)"Too many arguments!");
            }
            catch (ArrayIndexOutOfBoundsException e) {
                Log.log((Level)Level.FINE, (Throwable)e, (String)"Trying to access arg index, args = %s", (Object[])new Object[]{Arrays.toString(luaValues)});
                throw new IllegalArgumentException(String.format("Invalid Lua parameter count, needs %s, got %s", MethodDeclaration.this.luaArgs.size(), luaValues.length));
            }
            return this;
        }

        @Override
        public Object[] call() throws Exception {
            Object result;
            for (int i = 0; i < this.args.length; ++i) {
                Preconditions.checkState((boolean)this.isSet.contains(i), (String)"Parameter %s value not set", (Object[])new Object[]{i});
            }
            try {
                result = MethodDeclaration.this.method.invoke(this.target, this.args);
            }
            catch (InvocationTargetException e) {
                Throwable wrapper = e.getCause();
                throw Throwables.propagate((Throwable)(wrapper != null ? wrapper : e));
            }
            if (result instanceof IMultiReturn) {
                return MethodDeclaration.this.validateResult(((IMultiReturn)result).getObjects());
            }
            return MethodDeclaration.this.validateResult(new Object[]{result});
        }
    }
}

