/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.composed;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import openperipheral.adapter.IDescriptable;
import openperipheral.adapter.IMethodExecutor;
import openperipheral.api.LuaCallable;
import openperipheral.api.LuaType;

public class MethodsListerHelper<E extends IMethodExecutor> {
    private final Map<String, E> methods;

    public MethodsListerHelper(Map<String, E> methods) {
        this.methods = methods;
    }

    @LuaCallable(returnTypes={LuaType.STRING}, description="List all the methods available")
    public String listMethods() {
        ArrayList info = Lists.newArrayList();
        for (Map.Entry<String, E> e : this.methods.entrySet()) {
            IDescriptable m = ((IMethodExecutor)e.getValue()).getWrappedMethod();
            info.add(e.getKey() + m.signature());
        }
        return Joiner.on((String)", ").join((Iterable)info);
    }

    @LuaCallable(returnTypes={LuaType.TABLE}, description="Get a complete table of information about all available methods")
    public Map<?, ?> getAdvancedMethodsData() {
        HashMap info = Maps.newHashMap();
        for (Map.Entry<String, E> e : this.methods.entrySet()) {
            IDescriptable m = ((IMethodExecutor)e.getValue()).getWrappedMethod();
            info.put(e.getKey(), m.describe());
        }
        return info;
    }
}

