/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.composed;

import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import openmods.Log;
import openperipheral.adapter.AdapterManager;
import openperipheral.adapter.IAdapterMethodsList;
import openperipheral.adapter.IMethodExecutor;
import openperipheral.adapter.composed.ClassMethodsList;
import openperipheral.adapter.method.MethodDeclaration;
import openperipheral.api.LuaCallable;

public abstract class ClassMethodsListBuilder<E extends IMethodExecutor> {
    private final AdapterManager<?, E> manager;
    private Map<String, E> methods = Maps.newHashMap();
    public static final String ARG_TARGET = "target";

    public ClassMethodsListBuilder(AdapterManager<?, E> manager) {
        this.manager = manager;
    }

    protected abstract E createDummyWrapper(Object var1, MethodDeclaration var2);

    public void addMethodsFromObject(Object target) {
        this.addMethodsFromObject(this.methods, target);
    }

    private void addMethodsFromObject(Map<String, E> methods, Object target) {
        for (Method method : target.getClass().getMethods()) {
            LuaCallable callableMeta = method.getAnnotation(LuaCallable.class);
            if (callableMeta == null) continue;
            MethodDeclaration decl = new MethodDeclaration(method, callableMeta);
            for (String name : decl.getNames()) {
                methods.put(name, this.createDummyWrapper(target, decl));
            }
        }
    }

    public void addExternalAdapters(Class<?> cls) {
        for (IAdapterMethodsList<E> wrapper : this.manager.getExternalAdapters(cls)) {
            this.addMethods(wrapper);
        }
    }

    public void addInlineAdapter(Class<?> cls) {
        IAdapterMethodsList<E> wrapper = this.manager.getInlineAdapter(cls);
        this.addMethods(wrapper);
    }

    public void addMethods(IAdapterMethodsList<E> wrapper) {
        for (IMethodExecutor executor : wrapper.listMethods()) {
            for (String name : executor.getWrappedMethod().getNames()) {
                IMethodExecutor previous = this.methods.put(name, executor);
                if (previous == null) continue;
                Log.fine((String)"Previous defininition of Lua method '%s' overwritten by %s adapter", (Object[])new Object[]{name, wrapper.describeType()});
            }
        }
    }

    public Map<String, E> getMethodList() {
        return Collections.unmodifiableMap(this.methods);
    }

    public ClassMethodsList<E> create() {
        ClassMethodsList<E> result = new ClassMethodsList<E>(this.methods);
        this.methods = Maps.newHashMap();
        return result;
    }
}

