/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.composed;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import openperipheral.adapter.IMethodExecutor;
import openperipheral.adapter.IMethodsHolder;

public class ClassMethodsList<E extends IMethodExecutor>
implements IMethodsHolder<E> {
    private final Map<Integer, E> methodsByIndex;
    public final String[] methodNames;
    public final boolean hasMethods;

    ClassMethodsList(Map<String, E> methodsByName) {
        ImmutableMap.Builder methodsByIndex = ImmutableMap.builder();
        this.methodNames = new String[methodsByName.size()];
        int id = 0;
        boolean hasMethods = false;
        for (Map.Entry<String, E> e : methodsByName.entrySet()) {
            IMethodExecutor executor = (IMethodExecutor)e.getValue();
            this.methodNames[id] = e.getKey();
            methodsByIndex.put((Object)id++, (Object)executor);
            hasMethods |= !executor.isSynthetic();
        }
        this.hasMethods = hasMethods;
        this.methodsByIndex = methodsByIndex.build();
    }

    public E getMethod(int index) {
        return (E)((IMethodExecutor)this.methodsByIndex.get(index));
    }

    @Override
    public Collection<E> listMethods() {
        return Collections.unmodifiableCollection(this.methodsByIndex.values());
    }
}

