/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.composed;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import openperipheral.Config;
import openperipheral.adapter.IMethodExecutor;
import openperipheral.adapter.composed.ClassMethodsList;
import openperipheral.adapter.composed.ClassMethodsListBuilder;
import openperipheral.adapter.composed.LuaReflectionHelper;
import openperipheral.adapter.composed.MethodsListerHelper;

public abstract class ClassMethodsComposer<E extends IMethodExecutor> {
    protected abstract ClassMethodsListBuilder<E> createBuilder();

    public ClassMethodsList<E> createMethodsList(Class<?> cls) {
        ClassMethodsListBuilder<E> builder = this.createBuilder();
        List classHierarchy = Lists.reverse(ClassMethodsComposer.listSuperClasses(cls));
        HashSet allSuperInterfaces = Sets.newHashSet();
        for (Class c : classHierarchy) {
            allSuperInterfaces.addAll(ClassMethodsComposer.listSuperInterfaces(c));
        }
        for (Class c : allSuperInterfaces) {
            builder.addExternalAdapters(c);
        }
        for (Class c : classHierarchy) {
            builder.addExternalAdapters(c);
            builder.addInlineAdapter(c);
        }
        builder.addMethodsFromObject(new MethodsListerHelper<E>(builder.getMethodList()));
        if (Config.devMethods) {
            builder.addMethodsFromObject(new LuaReflectionHelper());
        }
        return builder.create();
    }

    private static List<Class<?>> listSuperClasses(Class<?> cls) {
        ArrayList superClasses = Lists.newArrayList();
        for (Class<?> currentClass = cls; currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            superClasses.add(currentClass);
        }
        return superClasses;
    }

    private static Set<Class<?>> listSuperInterfaces(Class<?> cls) {
        Class currentClass;
        HashSet superInterfaces = Sets.newHashSet();
        LinkedList tbd = Lists.newLinkedList();
        tbd.addAll(Arrays.asList(cls.getInterfaces()));
        while ((currentClass = (Class)tbd.poll()) != null) {
            superInterfaces.add(currentClass);
            tbd.addAll(Arrays.asList(currentClass.getInterfaces()));
        }
        return superInterfaces;
    }
}

