/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import openperipheral.TypeConversionRegistry;
import openperipheral.adapter.IDescriptable;
import openperipheral.adapter.IMethodExecutor;
import openperipheral.api.CallbackProperty;
import openperipheral.api.IPropertyCallback;
import openperipheral.api.LuaType;
import openperipheral.api.Property;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class PropertyListBuilder {
    private static final List<Object> EMPTY_ARGS = ImmutableList.of();
    private static final List<Object> NO_RETURNS = ImmutableList.of();

    private static IPropertyCallback createDefaultCallback(final Object owner) {
        return new IPropertyCallback(){

            @Override
            public void setField(Field field, Object value) {
                try {
                    field.set(owner, value);
                }
                catch (Throwable t) {
                    throw Throwables.propagate((Throwable)t);
                }
            }

            @Override
            public Object getField(Field field) {
                try {
                    return field.get(owner);
                }
                catch (Throwable t) {
                    throw Throwables.propagate((Throwable)t);
                }
            }
        };
    }

    private static ImmutablePair<GetterContext, SetterContext> createContexts(Field field, String name, LuaType type, String getterDescription, String setterDescription, boolean isDelegating, boolean readOnly) {
        SetterContext setter;
        GetterContext getter;
        int modifiers = field.getModifiers();
        Preconditions.checkArgument(((readOnly || !Modifier.isFinal(modifiers)) && !Modifier.isStatic(modifiers) ? 1 : 0) != 0, (Object)"Field marked with @Property can't be either final or static");
        field.setAccessible(true);
        if (Strings.isNullOrEmpty((String)name)) {
            name = field.getName();
        }
        String capitalizedName = StringUtils.capitalize((String)name);
        if (Strings.isNullOrEmpty((String)getterDescription)) {
            getterDescription = "Get field '" + name + "' value";
        }
        if (Strings.isNullOrEmpty((String)setterDescription)) {
            setterDescription = "Set field '" + name + "' value";
        }
        if (isDelegating) {
            getter = new DelegatingGetterContext(capitalizedName, getterDescription, type, field);
            setter = readOnly ? null : new DelegatingSetterContext(capitalizedName, setterDescription, type, field);
        } else {
            getter = new DefaultGetterContext(capitalizedName, getterDescription, type, field);
            setter = readOnly ? null : new DefaultSetterContext(capitalizedName, setterDescription, type, field);
        }
        return ImmutablePair.of((Object)getter, (Object)setter);
    }

    private static <E extends IMethodExecutor> void addMethods(Pair<GetterContext, SetterContext> context, IPropertyExecutorFactory<E> builder, List<E> output) {
        E getter = builder.createExecutor((FieldContext)context.getLeft());
        output.add(getter);
        if (context.getRight() != null) {
            E setter = builder.createExecutor((FieldContext)context.getRight());
            output.add(setter);
        }
    }

    public static <E extends IMethodExecutor> void buildPropertyList(Class<?> targetCls, IPropertyExecutorFactory<E> factory, List<E> output) {
        for (Field f : targetCls.getDeclaredFields()) {
            Annotation p = f.getAnnotation(Property.class);
            if (p != null) {
                PropertyListBuilder.addMethods(PropertyListBuilder.createContexts(f, p.name(), p.type(), p.getterDesc(), p.setterDesc(), false, p.readOnly()), factory, output);
                continue;
            }
            p = f.getAnnotation(CallbackProperty.class);
            if (p == null) continue;
            Preconditions.checkArgument((boolean)IPropertyCallback.class.isAssignableFrom(targetCls));
            PropertyListBuilder.addMethods(PropertyListBuilder.createContexts(f, p.name(), p.type(), p.getterDesc(), p.setterDesc(), true, p.readOnly()), factory, output);
        }
    }

    public static interface IPropertyExecutorFactory<E extends IMethodExecutor> {
        public E createExecutor(FieldContext var1);
    }

    private static class DelegatingSetterContext
    extends SetterContext {
        protected DelegatingSetterContext(String capitalizedName, String description, LuaType type, Field field) {
            super(capitalizedName, description, type, field);
        }

        @Override
        protected IPropertyCallback getCallback(Object target) {
            Preconditions.checkArgument((boolean)(target instanceof IPropertyCallback), (Object)"Invalid target. Probably not your fault");
            return (IPropertyCallback)target;
        }
    }

    private static class DelegatingGetterContext
    extends GetterContext {
        protected DelegatingGetterContext(String capitalizedName, String description, LuaType type, Field field) {
            super(capitalizedName, description, type, field);
        }

        @Override
        protected IPropertyCallback getCallback(Object target) {
            Preconditions.checkArgument((boolean)(target instanceof IPropertyCallback), (Object)"Invalid target. Probably not your fault");
            return (IPropertyCallback)target;
        }
    }

    private static class DefaultSetterContext
    extends SetterContext {
        protected DefaultSetterContext(String capitalizedName, String description, LuaType type, Field field) {
            super(capitalizedName, description, type, field);
        }

        @Override
        protected IPropertyCallback getCallback(Object target) {
            return PropertyListBuilder.createDefaultCallback(target);
        }
    }

    private static class DefaultGetterContext
    extends GetterContext {
        protected DefaultGetterContext(String capitalizedName, String description, LuaType type, Field field) {
            super(capitalizedName, description, type, field);
        }

        @Override
        protected IPropertyCallback getCallback(Object target) {
            return PropertyListBuilder.createDefaultCallback(target);
        }
    }

    private static abstract class SetterContext
    extends FieldContext {
        protected SetterContext(String capitalizedName, String description, LuaType type, Field field) {
            super("set" + capitalizedName, description, type, field);
        }

        @Override
        public Object call(Object target, Object ... args) {
            Preconditions.checkArgument((args.length == 1 ? 1 : 0) != 0, (Object)"Setter must have exactly one argument");
            Object arg = args[0];
            Object converted = TypeConversionRegistry.fromLua(arg, this.field.getType());
            Preconditions.checkNotNull((Object)converted, (Object)"Invalid value type");
            this.getCallback(target).setField(this.field, converted);
            return null;
        }

        @Override
        public String signature() {
            return "(value)";
        }

        @Override
        public Map<String, Object> describe() {
            HashMap args = Maps.newHashMap();
            args.put("name", "value");
            args.put("type", this.type.toString());
            args.put("description", "");
            Map<String, Object> result = super.describe();
            result.put("args", args);
            result.put("returnTypes", NO_RETURNS);
            return result;
        }
    }

    private static abstract class GetterContext
    extends FieldContext {
        protected GetterContext(String capitalizedName, String description, LuaType type, Field field) {
            super("get" + capitalizedName, description, type, field);
        }

        @Override
        public Object call(Object target, Object ... args) {
            Preconditions.checkArgument((args.length == 0 ? 1 : 0) != 0, (Object)"Getter has no arguments");
            Object result = this.getCallback(target).getField(this.field);
            return TypeConversionRegistry.toLua(result);
        }

        @Override
        public String signature() {
            return "()";
        }

        @Override
        public Map<String, Object> describe() {
            Map<String, Object> result = super.describe();
            result.put("args", EMPTY_ARGS);
            result.put("returnTypes", ImmutableList.of((Object)this.type.toString()));
            return result;
        }
    }

    public static abstract class FieldContext
    implements IDescriptable {
        private final String name;
        protected final String description;
        protected LuaType type;
        protected final Field field;

        protected FieldContext(String name, String description, LuaType type, Field field) {
            this.name = name;
            this.description = description;
            this.type = type;
            this.field = field;
        }

        public abstract Object call(Object var1, Object ... var2);

        protected abstract IPropertyCallback getCallback(Object var1);

        @Override
        public List<String> getNames() {
            return ImmutableList.of((Object)this.name);
        }

        @Override
        public Map<String, Object> describe() {
            HashMap result = Maps.newHashMap();
            result.put("description", this.description);
            return result;
        }
    }

    public static class PropertyExecutor
    implements IMethodExecutor {
        private final FieldContext context;

        protected PropertyExecutor(FieldContext context) {
            this.context = context;
        }

        @Override
        public IDescriptable getWrappedMethod() {
            return this.context;
        }

        @Override
        public boolean isSynthetic() {
            return false;
        }

        protected Object[] call(Object target, Object ... args) {
            return ArrayUtils.toArray((Object[])new Object[]{this.context.call(target, args)});
        }
    }
}

