/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import java.util.Map;
import java.util.Set;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import openmods.Log;
import openperipheral.Config;
import openperipheral.adapter.AdapterManager;
import openperipheral.adapter.CachingPeripheralFactory;
import openperipheral.adapter.IPeripheralFactory;
import openperipheral.adapter.SafePeripheralFactory;
import openperipheral.adapter.composed.ClassMethodsList;
import openperipheral.adapter.peripheral.AdapterPeripheral;
import openperipheral.adapter.peripheral.IPeripheralMethodExecutor;
import openperipheral.api.ICustomPeripheralProvider;
import openperipheral.api.Ignore;
import openperipheral.api.Volatile;

public class PeripheralHandlers
implements IPeripheralProvider {
    private static final IPeripheralFactory<TileEntity> NULL_HANDLER = new IPeripheralFactory<TileEntity>(){

        @Override
        public IPeripheral getPeripheral(TileEntity obj, int side) {
            return null;
        }
    };
    private static final IPeripheralFactory<TileEntity> ADAPTER_HANDLER = new SafePeripheralFactory(){

        @Override
        protected IPeripheral createPeripheral(TileEntity tile, int side) {
            ClassMethodsList<IPeripheralMethodExecutor> adapter = AdapterManager.peripherals.getAdapterClass(tile.getClass());
            return new AdapterPeripheral(adapter, tile);
        }
    };
    private static final IPeripheralFactory<TileEntity> ADAPTER_CACHING_HANDLER = new CachingPeripheralFactory(){

        @Override
        protected IPeripheral createPeripheral(TileEntity tile, int side) {
            ClassMethodsList<IPeripheralMethodExecutor> adapter = AdapterManager.peripherals.getAdapterClass(tile.getClass());
            return new AdapterPeripheral(adapter, tile);
        }
    };
    private static final IPeripheralFactory<TileEntity> PROVIDER_HANDLER = new SafePeripheralFactory(){

        @Override
        protected IPeripheral createPeripheral(TileEntity tile, int side) {
            return tile instanceof ICustomPeripheralProvider ? ((ICustomPeripheralProvider)tile).createPeripheral(side) : null;
        }
    };
    private static final IPeripheralFactory<TileEntity> PROVIDER_CACHING_HANDLER = new CachingPeripheralFactory(){

        @Override
        protected IPeripheral createPeripheral(TileEntity tile, int side) {
            return tile instanceof ICustomPeripheralProvider ? ((ICustomPeripheralProvider)tile).createPeripheral(side) : null;
        }
    };
    private static final Map<Class<? extends TileEntity>, IPeripheralFactory<TileEntity>> adaptedClasses = Maps.newHashMap();
    private static final Set<String> blacklist = ImmutableSet.copyOf((Object[])Config.teBlacklist);

    private static IPeripheralFactory<TileEntity> findFactoryForClass(Class<? extends TileEntity> teClass) {
        if (IPeripheral.class.isAssignableFrom(teClass)) {
            return NULL_HANDLER;
        }
        if (ICustomPeripheralProvider.class.isAssignableFrom(teClass)) {
            if (teClass.isAnnotationPresent(Volatile.class)) {
                Log.fine((String)"Adding non-caching provider handler for %s", (Object[])new Object[]{teClass});
                return PROVIDER_HANDLER;
            }
            Log.fine((String)"Adding caching provider handler for %s", (Object[])new Object[]{teClass});
            return PROVIDER_CACHING_HANDLER;
        }
        if (PeripheralHandlers.isIgnored(teClass)) {
            return NULL_HANDLER;
        }
        for (Class<? extends TileEntity> clazz : AdapterManager.peripherals.getAllAdaptableClasses()) {
            if (!clazz.isAssignableFrom(teClass)) continue;
            if (teClass.isAnnotationPresent(Volatile.class)) {
                Log.fine((String)"Adding non-caching adapter handler for %s", (Object[])new Object[]{teClass});
                return ADAPTER_HANDLER;
            }
            Log.fine((String)"Adding caching adapter handler for %s", (Object[])new Object[]{teClass});
            return ADAPTER_CACHING_HANDLER;
        }
        return NULL_HANDLER;
    }

    private static IPeripheralFactory<TileEntity> getFactoryForClass(Class<? extends TileEntity> teClass) {
        IPeripheralFactory<TileEntity> factory = adaptedClasses.get(teClass);
        if (factory == null) {
            factory = PeripheralHandlers.findFactoryForClass(teClass);
            adaptedClasses.put(teClass, factory);
        }
        return factory;
    }

    protected static boolean isIgnored(Class<? extends TileEntity> teClass) {
        String teClassName = teClass.getName();
        if (blacklist.contains(teClassName) || blacklist.contains(teClassName.toLowerCase())) {
            return true;
        }
        if (teClass.isAnnotationPresent(Ignore.class)) {
            return true;
        }
        try {
            teClass.getField("OPENPERIPHERAL_IGNORE");
            return true;
        }
        catch (NoSuchFieldException e) {
        }
        catch (Throwable t) {
            Log.warn((Throwable)t, (String)"Class %s doesn't cooperate", (Object[])new Object[]{teClass});
        }
        return false;
    }

    public static IPeripheral createPeripheral(Object target) {
        ClassMethodsList<IPeripheralMethodExecutor> adapter = AdapterManager.peripherals.getAdapterClass(target.getClass());
        return new AdapterPeripheral(adapter, target);
    }

    public IPeripheral getPeripheral(World world, int x, int y, int z, int side) {
        TileEntity te = world.func_72796_p(x, y, z);
        if (te == null) {
            return null;
        }
        IPeripheralFactory<TileEntity> factory = PeripheralHandlers.getFactoryForClass(te.getClass());
        return factory.getPeripheral(te, side);
    }
}

