/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import openmods.Log;
import openmods.utils.ReflectionHelper;
import openperipheral.adapter.IAdapterMethodsList;
import openperipheral.adapter.IMethodExecutor;
import openperipheral.adapter.method.MethodDeclaration;
import openperipheral.api.Freeform;
import openperipheral.api.IMethodProxy;
import openperipheral.api.LuaCallable;
import openperipheral.api.LuaMethod;
import openperipheral.api.Prefixed;
import openperipheral.api.ProxyArg;
import openperipheral.api.ProxyArgs;

public abstract class AdapterWrapper<E extends IMethodExecutor>
implements IAdapterMethodsList<E> {
    protected final List<E> methods;
    protected final Class<?> targetCls;
    protected final Class<?> adapterClass;

    private static boolean isFreeform(AnnotatedElement element, boolean defaultValue) {
        Freeform freeform = element.getAnnotation(Freeform.class);
        return freeform != null ? freeform.value() : defaultValue;
    }

    private static String[] getPrefixes(AnnotatedElement element, String[] defaultValue) {
        if (element == null) {
            return defaultValue;
        }
        Prefixed prefixed = element.getAnnotation(Prefixed.class);
        return prefixed != null ? prefixed.value() : defaultValue;
    }

    protected AdapterWrapper(Class<?> adapterClass, Class<?> targetClass) {
        this.adapterClass = adapterClass;
        this.targetCls = targetClass;
        this.methods = ImmutableList.copyOf(this.buildMethodList());
    }

    @Override
    public List<E> listMethods() {
        return this.methods;
    }

    @Override
    public Class<?> getTargetClass() {
        return this.targetCls;
    }

    @Override
    public String describeType() {
        return "generated (source: " + this.adapterClass.toString() + ")";
    }

    protected abstract List<E> buildMethodList();

    protected void namesFromAnnotation(String[] prefixes, MethodDeclaration decl) {
        int i = 0;
        for (String name : prefixes) {
            decl.nameJavaArg(i++, name);
        }
    }

    protected abstract void validateArgTypes(MethodDeclaration var1);

    protected abstract void nameDefaultParameters(MethodDeclaration var1);

    protected MethodDeclaration createDeclaration(Method method) {
        LuaMethod methodAnn = method.getAnnotation(LuaMethod.class);
        if (methodAnn != null) {
            return new MethodDeclaration(method, methodAnn);
        }
        LuaCallable callableAnn = method.getAnnotation(LuaCallable.class);
        if (callableAnn != null) {
            return new MethodDeclaration(method, callableAnn);
        }
        return null;
    }

    private void addProxyArgs(Map<String, Method> result, String defaultName, Class<?>[] defaultArgs, ProxyArg arg) {
        Method proxiedMethod;
        Object[] args;
        String name = arg.argName();
        Object[] names = arg.methodNames();
        if (names.length == 0) {
            names = new String[]{defaultName};
        }
        if ((args = arg.args()).length == 1 && args[0] == Void.TYPE) {
            args = defaultArgs;
        }
        Preconditions.checkState(((proxiedMethod = ReflectionHelper.getMethod(this.targetCls, (String[])names, (Class[])args)) != null ? 1 : 0) != 0, (String)"Can find proxy argument '%s' for method %s %s in class (adapter: %s)", (Object[])new Object[]{name, this.targetCls, Arrays.toString(names), Arrays.toString(args), this.targetCls, this.adapterClass});
        proxiedMethod.setAccessible(true);
        Method prev = result.put(name, proxiedMethod);
        Preconditions.checkState((prev == null ? 1 : 0) != 0, (String)"Duplicated proxy arg name '%s' in adapter '%s'", (Object[])new Object[]{name, this.adapterClass});
    }

    protected static IMethodProxy createProxy(final Object target, final Method method) {
        return new IMethodProxy(){

            @Override
            public <T> T call(Object ... args) {
                try {
                    return (T)method.invoke(target, args);
                }
                catch (Throwable t) {
                    throw Throwables.propagate((Throwable)t);
                }
            }
        };
    }

    protected static MethodDeclaration.CallWrap nameAdapterMethods(Object target, Map<String, Method> proxyArgs, MethodDeclaration.CallWrap wrap) {
        for (Map.Entry<String, Method> e : proxyArgs.entrySet()) {
            wrap.setJavaArg(e.getKey(), AdapterWrapper.createProxy(target, e.getValue()));
        }
        return wrap;
    }

    protected List<E> buildMethodList(boolean defaultIsFreeform, MethodExecutorFactory<E> factory) {
        Method[] clsMethods;
        ArrayList result = Lists.newArrayList();
        boolean clsIsFreeform = AdapterWrapper.isFreeform(this.adapterClass, defaultIsFreeform);
        String[] packagePrefixes = AdapterWrapper.getPrefixes(this.adapterClass.getPackage(), null);
        String[] classPrefixes = AdapterWrapper.getPrefixes(this.adapterClass, packagePrefixes);
        try {
            clsMethods = this.adapterClass.getDeclaredMethods();
        }
        catch (Throwable t) {
            Log.severe((Throwable)t, (String)"Can't get adapter %s methods (possible sideness fail), bailing out", (Object[])new Object[]{this.adapterClass});
            return result;
        }
        for (Method method : clsMethods) {
            ProxyArgs proxyArgs;
            MethodDeclaration decl = this.createDeclaration(method);
            if (decl == null) continue;
            HashMap allProxyArgs = Maps.newHashMap();
            Class<?>[] luaArgs = decl.getLuaArgTypes();
            ProxyArg proxyArg = method.getAnnotation(ProxyArg.class);
            if (proxyArg != null) {
                this.addProxyArgs(allProxyArgs, method.getName(), luaArgs, proxyArg);
            }
            if ((proxyArgs = method.getAnnotation(ProxyArgs.class)) != null) {
                for (ProxyArg arg : proxyArgs.value()) {
                    this.addProxyArgs(allProxyArgs, method.getName(), luaArgs, arg);
                }
            }
            E exec = factory.createExecutor(method, decl, (Map<String, Method>)ImmutableMap.copyOf((Map)allProxyArgs));
            if (!AdapterWrapper.isFreeform(method, clsIsFreeform)) {
                String[] methodPrefixes = AdapterWrapper.getPrefixes(method, classPrefixes);
                if (methodPrefixes != null) {
                    this.namesFromAnnotation(methodPrefixes, decl);
                } else {
                    this.nameDefaultParameters(decl);
                }
            }
            this.validateArgTypes(decl);
            for (String proxyArgName : allProxyArgs.keySet()) {
                decl.declareJavaArgType(proxyArgName, IMethodProxy.class);
            }
            decl.validate();
            result.add(exec);
        }
        return result;
    }

    protected static interface MethodExecutorFactory<E extends IMethodExecutor> {
        public E createExecutor(Method var1, MethodDeclaration var2, Map<String, Method> var3);
    }
}

