/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import dan200.computercraft.api.lua.ILuaObject;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import openmods.Log;
import openperipheral.adapter.IAdapterMethodsList;
import openperipheral.adapter.IMethodExecutor;
import openperipheral.adapter.composed.ClassMethodsComposer;
import openperipheral.adapter.composed.ClassMethodsList;
import openperipheral.adapter.composed.ClassMethodsListBuilder;
import openperipheral.adapter.object.IObjectMethodExecutor;
import openperipheral.adapter.object.LuaObjectWrapper;
import openperipheral.adapter.object.ObjectAdapterWrapper;
import openperipheral.adapter.object.ObjectMethodsListBuilder;
import openperipheral.adapter.peripheral.IPeripheralMethodExecutor;
import openperipheral.adapter.peripheral.PeripheralExternalAdapterWrapper;
import openperipheral.adapter.peripheral.PeripheralInlineAdapterWrapper;
import openperipheral.adapter.peripheral.PeripheralMethodsListBuilder;
import openperipheral.api.IAdapterBase;
import openperipheral.api.IObjectAdapter;
import openperipheral.api.IPeripheralAdapter;

public abstract class AdapterManager<A extends IAdapterBase, E extends IMethodExecutor> {
    private static final ClassMethodsComposer<IObjectMethodExecutor> OBJECT_COMPOSER = new ClassMethodsComposer<IObjectMethodExecutor>(){

        @Override
        protected ClassMethodsListBuilder<IObjectMethodExecutor> createBuilder() {
            return new ObjectMethodsListBuilder();
        }
    };
    public static final AdapterManager<IObjectAdapter, IObjectMethodExecutor> objects = new AdapterManager<IObjectAdapter, IObjectMethodExecutor>(){

        @Override
        protected ClassMethodsList<IObjectMethodExecutor> collectMethods(Class<?> targetClass) {
            return OBJECT_COMPOSER.createMethodsList(targetClass);
        }

        @Override
        protected IAdapterMethodsList<IObjectMethodExecutor> wrapExternalAdapter(IObjectAdapter adapter) {
            return new ObjectAdapterWrapper.External(adapter);
        }

        @Override
        protected IAdapterMethodsList<IObjectMethodExecutor> wrapInlineAdapter(Class<?> targetClass) {
            return new ObjectAdapterWrapper.Inline(targetClass);
        }
    };
    private static final ClassMethodsComposer<IPeripheralMethodExecutor> PERIPHERAL_COMPOSER = new ClassMethodsComposer<IPeripheralMethodExecutor>(){

        @Override
        protected ClassMethodsListBuilder<IPeripheralMethodExecutor> createBuilder() {
            return new PeripheralMethodsListBuilder();
        }
    };
    public static final AdapterManager<IPeripheralAdapter, IPeripheralMethodExecutor> peripherals = new AdapterManager<IPeripheralAdapter, IPeripheralMethodExecutor>(){

        @Override
        protected ClassMethodsList<IPeripheralMethodExecutor> collectMethods(Class<?> targetClass) {
            return PERIPHERAL_COMPOSER.createMethodsList(targetClass);
        }

        @Override
        protected IAdapterMethodsList<IPeripheralMethodExecutor> wrapExternalAdapter(IPeripheralAdapter adapter) {
            return new PeripheralExternalAdapterWrapper(adapter);
        }

        @Override
        protected IAdapterMethodsList<IPeripheralMethodExecutor> wrapInlineAdapter(Class<?> targetClass) {
            return new PeripheralInlineAdapterWrapper(targetClass);
        }
    };
    private final Multimap<Class<?>, IAdapterMethodsList<E>> externalAdapters = HashMultimap.create();
    private final Map<Class<?>, IAdapterMethodsList<E>> internalAdapters = Maps.newHashMap();
    private final Map<Class<?>, ClassMethodsList<E>> classes = Maps.newHashMap();

    public static void addObjectAdapter(IObjectAdapter adapter) {
        objects.addAdapter(adapter);
    }

    public static void addPeripheralAdapter(IPeripheralAdapter adapter) {
        peripherals.addAdapter(adapter);
    }

    public static void addInlinePeripheralAdapter(Class<?> cls) {
        peripherals.addInlineAdapter(cls);
    }

    public Set<Class<?>> getAllAdaptableClasses() {
        return Sets.union((Set)this.externalAdapters.keySet(), this.internalAdapters.keySet());
    }

    public Collection<IAdapterMethodsList<E>> listExternalAdapters() {
        return Collections.unmodifiableCollection(this.externalAdapters.values());
    }

    public Map<Class<?>, ClassMethodsList<E>> listCollectedClasses() {
        return Collections.unmodifiableMap(this.classes);
    }

    public void addAdapter(A adapter) {
        IAdapterMethodsList<E> wrapper;
        try {
            wrapper = this.wrapExternalAdapter(adapter);
        }
        catch (Throwable e) {
            Log.warn((Throwable)e, (String)"Something went terribly wrong while adding internal adapter '%s'. It will be disabled", (Object[])new Object[]{adapter.getClass()});
            return;
        }
        Class<?> targetCls = wrapper.getTargetClass();
        Preconditions.checkArgument((!Object.class.equals(wrapper.getTargetClass()) ? 1 : 0) != 0, (Object)"Can't add adapter for Object class");
        Log.info((String)"Registering %s adapter for class %s", (Object[])new Object[]{wrapper.describeType(), targetCls});
        this.externalAdapters.put(wrapper.getTargetClass(), wrapper);
    }

    public void addInlineAdapter(Class<?> targetCls) {
        IAdapterMethodsList<E> wrapper = this.wrapInlineAdapter(targetCls);
        Log.info((String)"Registering auto-created adapter for class %s", (Object[])new Object[]{targetCls});
        this.internalAdapters.put(targetCls, wrapper);
    }

    public ClassMethodsList<E> getAdapterClass(Class<?> targetCls) {
        ClassMethodsList<E> value = this.classes.get(targetCls);
        if (value == null) {
            value = this.collectMethods(targetCls);
            this.classes.put(targetCls, value);
        }
        return value;
    }

    public Collection<IAdapterMethodsList<E>> getExternalAdapters(Class<?> targetCls) {
        return Collections.unmodifiableCollection(this.externalAdapters.get(targetCls));
    }

    public IAdapterMethodsList<E> getInlineAdapter(Class<?> targetCls) {
        IAdapterMethodsList<E> wrapper = this.internalAdapters.get(targetCls);
        if (wrapper == null) {
            wrapper = this.wrapInlineAdapter(targetCls);
            this.internalAdapters.put(targetCls, wrapper);
        }
        return wrapper;
    }

    protected abstract ClassMethodsList<E> collectMethods(Class<?> var1);

    protected abstract IAdapterMethodsList<E> wrapExternalAdapter(A var1);

    protected abstract IAdapterMethodsList<E> wrapInlineAdapter(Class<?> var1);

    public static ILuaObject wrapObject(Object o) {
        return LuaObjectWrapper.wrap(objects, o);
    }
}

