/*
 * Decompiled with CFR 0.152.
 */
package openperipheral;

import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import java.util.EnumSet;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.world.World;

public class TickHandler
implements ITickHandler {
    private static Map<Integer, Queue<Runnable>> callbacks = Maps.newHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Queue<Runnable> getWorldQueue(int worldId) {
        Map<Integer, Queue<Runnable>> map = callbacks;
        synchronized (map) {
            ConcurrentLinkedQueue result = callbacks.get(worldId);
            if (result == null) {
                result = Queues.newConcurrentLinkedQueue();
                callbacks.put(worldId, result);
            }
            return result;
        }
    }

    public static void addTickCallback(World world, Runnable callback) {
        int worldId = world.field_73011_w.field_76574_g;
        TickHandler.getWorldQueue(worldId).add(callback);
    }

    public String getLabel() {
        return "OpenPeripheralCore";
    }

    public void tickEnd(EnumSet<TickType> type, Object ... tickObjects) {
        if (type.contains(TickType.WORLD)) {
            World world = (World)tickObjects[0];
            if (!world.field_72995_K) {
                Runnable callback;
                int worldId = world.field_73011_w.field_76574_g;
                Queue<Runnable> callbacks = TickHandler.getWorldQueue(worldId);
                while ((callback = callbacks.poll()) != null) {
                    callback.run();
                }
            }
        }
    }

    public EnumSet<TickType> ticks() {
        return EnumSet.of(TickType.WORLD);
    }

    public void tickStart(EnumSet<TickType> type, Object ... tickData) {
    }
}

