/*
 * Decompiled with CFR 0.152.
 */
package openperipheral;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.Loader;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Vec3;
import openmods.Log;
import openperipheral.Config;
import openperipheral.api.IIntegrationModule;
import openperipheral.integration.vanilla.ModuleVanilla;

public class IntegrationModuleRegistry {
    private static Map<String, IIntegrationModule> registeredModules = Maps.newHashMap();
    private static Map<String, IIntegrationModule> selectedModules = Maps.newHashMap();

    public static void registerModule(IIntegrationModule module) {
        String modId = module.getModId();
        IIntegrationModule prev = registeredModules.put(modId, module);
        Preconditions.checkState((prev == null ? 1 : 0) != 0, (String)"Conflicting adapters for mod '%s': %s, %s", (Object[])new Object[]{module, prev});
    }

    public static void selectLoadedModules() {
        HashSet blacklist = Sets.newHashSet();
        for (String modId : Config.modBlacklist) {
            blacklist.add(modId.toLowerCase());
        }
        if (!blacklist.contains(ModuleVanilla.DUMMY_VANILLA_MODID)) {
            selectedModules.put(ModuleVanilla.DUMMY_VANILLA_MODID, new ModuleVanilla());
        }
        for (Map.Entry<String, IIntegrationModule> e : registeredModules.entrySet()) {
            String modId = e.getKey();
            if (!Loader.isModLoaded((String)modId)) continue;
            if (blacklist.contains(modId.toLowerCase())) {
                Log.info((String)"Mod %s is loaded, but integration not enabled due to blacklist", (Object[])new Object[]{modId});
                continue;
            }
            IIntegrationModule module = e.getValue();
            Log.info((String)"Enabling module %s for %s ", (Object[])new Object[]{module, modId});
            selectedModules.put(modId, module);
        }
        Log.info((String)"Module loading finished (enabled: %s, disabled: %s)", (Object[])new Object[]{selectedModules.keySet(), Sets.difference(registeredModules.keySet(), selectedModules.keySet())});
    }

    public static Collection<IIntegrationModule> loadedModules() {
        return selectedModules.values();
    }

    private static void visitModules(ModuleVisitor visitor) {
        Iterator<Map.Entry<String, IIntegrationModule>> it = selectedModules.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, IIntegrationModule> e = it.next();
            try {
                visitor.visit(e.getValue());
            }
            catch (Throwable t) {
                Log.warn((Throwable)t, (String)"Integration module '%s' failed during operation '%s' and will be disabled", (Object[])new Object[]{e.getKey(), visitor.getOperation()});
                it.remove();
            }
        }
    }

    public static void initAllModules() {
        IntegrationModuleRegistry.visitModules(new ModuleVisitor(){

            @Override
            public void visit(IIntegrationModule module) {
                module.init();
            }

            @Override
            public String getOperation() {
                return "init";
            }
        });
    }

    public static void appendEntityInfo(final Map<String, Object> map, final Entity entity, final Vec3 relativePos) {
        IntegrationModuleRegistry.visitModules(new ModuleVisitor(){

            @Override
            public void visit(IIntegrationModule module) {
                module.appendEntityInfo(map, entity, relativePos);
            }

            @Override
            public String getOperation() {
                return "appendEntityInfo";
            }
        });
    }

    public static void appendItemInfo(final Map<String, Object> map, final ItemStack item) {
        IntegrationModuleRegistry.visitModules(new ModuleVisitor(){

            @Override
            public void visit(IIntegrationModule module) {
                module.appendItemInfo(map, item);
            }

            @Override
            public String getOperation() {
                return "appendItemInfo";
            }
        });
    }

    private static interface ModuleVisitor {
        public String getOperation();

        public void visit(IIntegrationModule var1);
    }
}

