/*
 * Decompiled with CFR 0.152.
 */
package openblocks.utils;

import cpw.mods.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import openblocks.OpenBlocksCorePlugin;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class AsmUtils {
    public static byte[] applyVisitor(byte[] bytes, TransformContext context) {
        ClassReader cr = new ClassReader(bytes);
        ClassWriter cw = new ClassWriter(cr, 2);
        ClassVisitor mod = context.createVisitor((ClassVisitor)cw);
        cr.accept(mod, 0);
        return cw.toByteArray();
    }

    public static interface TransformContext {
        public ClassVisitor createVisitor(ClassVisitor var1);
    }

    public static class MethodMatcher {
        private final String clsName;
        private final String description;
        private final String srgName;
        private final String mcpName;

        public MethodMatcher(String clsName, String description, String mcpName, String srgName) {
            this.clsName = clsName;
            this.description = description;
            this.srgName = srgName;
            this.mcpName = mcpName;
        }

        public boolean match(String methodName, String methodDesc) {
            if (!methodDesc.equals(this.description)) {
                return false;
            }
            if (methodName.equals(this.mcpName)) {
                return true;
            }
            if (!OpenBlocksCorePlugin.isRuntimeDeobfuscated) {
                return false;
            }
            String mapped = FMLDeobfuscatingRemapper.INSTANCE.mapMethodName(this.clsName, methodName, methodDesc);
            return mapped.equals(this.srgName);
        }
    }
}

